/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    public static final int MAJOR = 5;
    public static final int MINOR = 4;
    public static final int PATCH = 5;
    public static final int BUILD = 1;
    public static final Type RELEASE = Type.LTS;
    public final int major;
    public final int minor;
    public final int patch;
    public final int build;
    public final Type release;

    public Version(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = 0;
        this.release = Type.UNKNOWN;
    }

    public Version(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = n4;
        this.release = Type.UNKNOWN;
    }

    public Version(int n, int n2, int n3, int n4, Type type) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = n4;
        this.release = type;
    }

    public static Version of(int n, int n2, int n3) {
        return new Version(n, n2, n3);
    }

    public static Version of(int n, int n2, int n3, int n4) {
        return new Version(n, n2, n3, n4);
    }

    public static Version of(int n, int n2, int n3, int n4, Type type) {
        return new Version(n, n2, n3, n4, type);
    }

    public static Version getVersion() {
        return new Version(5, 4, 5, 1, RELEASE);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && this.build == version.build;
    }

    public String getVersionString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public String getReleaseStatus() {
        if (this.release.equals((Object)Type.UNKNOWN)) {
            return "";
        }
        return this.release.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return String.format("%d.%d.%d-%d %s", this.major, this.minor, this.patch, this.build, this.getReleaseStatus());
    }

    @Override
    public int compareTo(Version version) {
        if (version.major != this.major) {
            return Integer.compare(this.major, version.major);
        }
        if (version.minor != this.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        if (version.patch != this.patch) {
            return Integer.compare(this.patch, version.patch);
        }
        return 0;
    }

    public boolean isUpperThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isLowerThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public static enum Type {
        LTS,
        STABLE,
        BETA,
        ALPHA,
        DEV,
        EXPERIMENTAL,
        UNKNOWN;

        private static final Map<String, Type> types;
        public static final Map<String, Type> unModTypes;

        static {
            types = new HashMap<String, Type>();
            unModTypes = Collections.unmodifiableMap(types);
            Arrays.asList(Type.values()).forEach(type -> types.put(type.name().substring(0, Math.min(type.name().length(), 3)).toLowerCase(Locale.ENGLISH), (Type)((Object)type)));
        }
    }
}

