/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import pro.gravit.repackage.io.netty.util.internal.Cleaner;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, byteBuffer);
            }
            catch (Throwable throwable) {
                PlatformDependent0.throwException(throwable);
            }
        } else {
            CleanerJava9.freeDirectBufferPrivileged(byteBuffer);
        }
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer byteBuffer) {
        Exception exception = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

            @Override
            public Exception run() {
                try {
                    INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, byteBuffer);
                }
                catch (InvocationTargetException invocationTargetException) {
                    return invocationTargetException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return illegalAccessException;
                }
                return null;
            }
        });
        if (exception != null) {
            PlatformDependent0.throwException(exception);
        }
    }

    static {
        Throwable throwable;
        Method method;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Method method = PlatformDependent0.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        method.invoke((Object)PlatformDependent0.UNSAFE, byteBuffer);
                        return method;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return noSuchMethodException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return invocationTargetException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return illegalAccessException;
                    }
                }
            });
            if (object instanceof Throwable) {
                method = null;
                throwable = (Throwable)object;
            } else {
                method = (Method)object;
                throwable = null;
            }
        } else {
            method = null;
            throwable = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        INVOKE_CLEANER = method;
    }
}

