/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultThreadFactory;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

@Deprecated
public final class ThreadDeathWatcher {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadDeathWatcher.class);
    static final ThreadFactory threadFactory;
    private static final Queue<Entry> pendingEntries;
    private static final Watcher watcher;
    private static final AtomicBoolean started;
    private static volatile Thread watcherThread;

    public static void watch(Thread thread, Runnable runnable) {
        ObjectUtil.checkNotNull(thread, "thread");
        ObjectUtil.checkNotNull(runnable, "task");
        if (!thread.isAlive()) {
            throw new IllegalArgumentException("thread must be alive.");
        }
        ThreadDeathWatcher.schedule(thread, runnable, true);
    }

    public static void unwatch(Thread thread, Runnable runnable) {
        ThreadDeathWatcher.schedule(ObjectUtil.checkNotNull(thread, "thread"), ObjectUtil.checkNotNull(runnable, "task"), false);
    }

    private static void schedule(Thread thread, Runnable runnable, boolean bl) {
        pendingEntries.add(new Entry(thread, runnable, bl));
        if (started.compareAndSet(false, true)) {
            final Thread thread2 = threadFactory.newThread(watcher);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread2.setContextClassLoader(null);
                    return null;
                }
            });
            thread2.start();
            watcherThread = thread2;
        }
    }

    public static boolean awaitInactivity(long l, TimeUnit timeUnit) throws InterruptedException {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        Thread thread = watcherThread;
        if (thread != null) {
            thread.join(timeUnit.toMillis(l));
            return !thread.isAlive();
        }
        return true;
    }

    private ThreadDeathWatcher() {
    }

    static {
        pendingEntries = new ConcurrentLinkedQueue<Entry>();
        watcher = new Watcher();
        started = new AtomicBoolean();
        String string = "threadDeathWatcher";
        String string2 = SystemPropertyUtil.get("pro.gravit.repackage.io.netty.serviceThreadPrefix");
        if (!StringUtil.isNullOrEmpty(string2)) {
            string = string2 + string;
        }
        threadFactory = new DefaultThreadFactory(string, true, 1, null);
    }

    private static final class Entry {
        final Thread thread;
        final Runnable task;
        final boolean isWatch;

        Entry(Thread thread, Runnable runnable, boolean bl) {
            this.thread = thread;
            this.task = runnable;
            this.isWatch = bl;
        }

        public int hashCode() {
            return this.thread.hashCode() ^ this.task.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.thread == entry.thread && this.task == entry.task;
        }
    }

    private static final class Watcher
    implements Runnable {
        private final List<Entry> watchees = new ArrayList<Entry>();

        private Watcher() {
        }

        @Override
        public void run() {
            while (true) {
                this.fetchWatchees();
                this.notifyWatchees();
                this.fetchWatchees();
                this.notifyWatchees();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.watchees.isEmpty() || !pendingEntries.isEmpty()) continue;
                boolean bl = started.compareAndSet(true, false);
                assert (bl);
                if (pendingEntries.isEmpty() || !started.compareAndSet(false, true)) break;
            }
        }

        private void fetchWatchees() {
            Entry entry;
            while ((entry = (Entry)pendingEntries.poll()) != null) {
                if (entry.isWatch) {
                    this.watchees.add(entry);
                    continue;
                }
                this.watchees.remove(entry);
            }
        }

        private void notifyWatchees() {
            List<Entry> list = this.watchees;
            int n = 0;
            while (n < list.size()) {
                Entry entry = list.get(n);
                if (!entry.thread.isAlive()) {
                    list.remove(n);
                    try {
                        entry.task.run();
                    }
                    catch (Throwable throwable) {
                        logger.warn("Thread death watcher task raised an exception:", throwable);
                    }
                    continue;
                }
                ++n;
            }
        }
    }
}

