/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import pro.gravit.repackage.io.netty.resolver.InetNameResolver;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor eventExecutor) {
        super(eventExecutor);
    }

    @Override
    protected void doResolve(String string, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess(SocketUtils.addressByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(Arrays.asList(SocketUtils.allAddressesByName(string)));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }
}

