/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ipfilter;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRuleType;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;

public final class IpSubnetFilterRule
implements IpFilterRule,
Comparable<IpSubnetFilterRule> {
    private final IpFilterRule filterRule;
    private final String ipAddress;

    public IpSubnetFilterRule(String string, int n, IpFilterRuleType ipFilterRuleType) {
        try {
            this.ipAddress = string;
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName(string), n, ipFilterRuleType);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("ipAddress", unknownHostException);
        }
    }

    public IpSubnetFilterRule(InetAddress inetAddress, int n, IpFilterRuleType ipFilterRuleType) {
        this.ipAddress = inetAddress.getHostAddress();
        this.filterRule = IpSubnetFilterRule.selectFilterRule(inetAddress, n, ipFilterRuleType);
    }

    private static IpFilterRule selectFilterRule(InetAddress inetAddress, int n, IpFilterRuleType ipFilterRuleType) {
        ObjectUtil.checkNotNull(inetAddress, "ipAddress");
        ObjectUtil.checkNotNull(ipFilterRuleType, "ruleType");
        if (inetAddress instanceof Inet4Address) {
            return new Ip4SubnetFilterRule((Inet4Address)inetAddress, n, ipFilterRuleType);
        }
        if (inetAddress instanceof Inet6Address) {
            return new Ip6SubnetFilterRule((Inet6Address)inetAddress, n, ipFilterRuleType);
        }
        throw new IllegalArgumentException("Only IPv4 and IPv6 addresses are supported");
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        return this.filterRule.matches(inetSocketAddress);
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.filterRule.ruleType();
    }

    String getIpAddress() {
        return this.ipAddress;
    }

    IpFilterRule getFilterRule() {
        return this.filterRule;
    }

    @Override
    public int compareTo(IpSubnetFilterRule ipSubnetFilterRule) {
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            return IpSubnetFilterRule.compareInt(((Ip4SubnetFilterRule)this.filterRule).networkAddress, ((Ip4SubnetFilterRule)ipSubnetFilterRule.filterRule).networkAddress);
        }
        return ((Ip6SubnetFilterRule)this.filterRule).networkAddress.compareTo(((Ip6SubnetFilterRule)ipSubnetFilterRule.filterRule).networkAddress);
    }

    @Override
    int compareTo(InetSocketAddress inetSocketAddress) {
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            Ip4SubnetFilterRule ip4SubnetFilterRule = (Ip4SubnetFilterRule)this.filterRule;
            return IpSubnetFilterRule.compareInt(ip4SubnetFilterRule.networkAddress, NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()) & ip4SubnetFilterRule.subnetMask);
        }
        Ip6SubnetFilterRule ip6SubnetFilterRule = (Ip6SubnetFilterRule)this.filterRule;
        return ip6SubnetFilterRule.networkAddress.compareTo(Ip6SubnetFilterRule.ipToInt((Inet6Address)inetSocketAddress.getAddress()).and(ip6SubnetFilterRule.networkAddress));
    }

    private static int compareInt(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    static final class Ip6SubnetFilterRule
    implements IpFilterRule {
        private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
        private final BigInteger networkAddress;
        private final BigInteger subnetMask;
        private final IpFilterRuleType ruleType;

        private Ip6SubnetFilterRule(Inet6Address inet6Address, int n, IpFilterRuleType ipFilterRuleType) {
            if (n < 0 || n > 128) {
                throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", n));
            }
            this.subnetMask = Ip6SubnetFilterRule.prefixToSubnetMask(n);
            this.networkAddress = Ip6SubnetFilterRule.ipToInt(inet6Address).and(this.subnetMask);
            this.ruleType = ipFilterRuleType;
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress instanceof Inet6Address) {
                BigInteger bigInteger = Ip6SubnetFilterRule.ipToInt((Inet6Address)inetAddress);
                return bigInteger.and(this.subnetMask).equals(this.subnetMask) || bigInteger.and(this.subnetMask).equals(this.networkAddress);
            }
            return false;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static BigInteger ipToInt(Inet6Address inet6Address) {
            byte[] byArray = inet6Address.getAddress();
            assert (byArray.length == 16);
            return new BigInteger(byArray);
        }

        private static BigInteger prefixToSubnetMask(int n) {
            return MINUS_ONE.shiftLeft(128 - n);
        }
    }

    static final class Ip4SubnetFilterRule
    implements IpFilterRule {
        private final int networkAddress;
        private final int subnetMask;
        private final IpFilterRuleType ruleType;

        private Ip4SubnetFilterRule(Inet4Address inet4Address, int n, IpFilterRuleType ipFilterRuleType) {
            if (n < 0 || n > 32) {
                throw new IllegalArgumentException(String.format("IPv4 requires the subnet prefix to be in range of [0,32]. The prefix was: %d", n));
            }
            this.subnetMask = Ip4SubnetFilterRule.prefixToSubnetMask(n);
            this.networkAddress = NetUtil.ipv4AddressToInt(inet4Address) & this.subnetMask;
            this.ruleType = ipFilterRuleType;
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress instanceof Inet4Address) {
                int n = NetUtil.ipv4AddressToInt((Inet4Address)inetAddress);
                return (n & this.subnetMask) == this.networkAddress;
            }
            return false;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static int prefixToSubnetMask(int n) {
            return (int)(-1L << 32 - n);
        }
    }
}

