/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.compression;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel;
import pro.gravit.repackage.io.netty.handler.codec.CodecException;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibCodecFactory;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibWrapper;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

abstract class DeflateDecoder
extends WebSocketExtensionDecoder {
    static final ByteBuf FRAME_TAIL = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{0, 0, -1, -1})).asReadOnly();
    static final ByteBuf EMPTY_DEFLATE_BLOCK = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{0})).asReadOnly();
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionDecoderFilter;
    private EmbeddedChannel decoder;

    DeflateDecoder(boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        this.noContext = bl;
        this.extensionDecoderFilter = ObjectUtil.checkNotNull(webSocketExtensionFilter, "extensionDecoderFilter");
    }

    protected WebSocketExtensionFilter extensionDecoderFilter() {
        return this.extensionDecoderFilter;
    }

    protected abstract boolean appendFrameTail(WebSocketFrame var1);

    protected abstract int newRsv(WebSocketFrame var1);

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        WebSocketFrame webSocketFrame2;
        ByteBuf byteBuf = this.decompressContent(channelHandlerContext, webSocketFrame);
        if (webSocketFrame instanceof TextWebSocketFrame) {
            webSocketFrame2 = new TextWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            webSocketFrame2 = new BinaryWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            webSocketFrame2 = new ContinuationWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else {
            throw new CodecException("unexpected frame type: " + webSocketFrame.getClass().getName());
        }
        list.add(webSocketFrame2);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    private ByteBuf decompressContent(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame) {
        ByteBuf byteBuf;
        if (this.decoder == null) {
            if (!(webSocketFrame instanceof TextWebSocketFrame) && !(webSocketFrame instanceof BinaryWebSocketFrame)) {
                throw new CodecException("unexpected initial frame type: " + webSocketFrame.getClass().getName());
            }
            this.decoder = new EmbeddedChannel(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.NONE));
        }
        boolean bl = webSocketFrame.content().isReadable();
        boolean bl2 = EMPTY_DEFLATE_BLOCK.equals(webSocketFrame.content());
        this.decoder.writeInbound(webSocketFrame.content().retain());
        if (this.appendFrameTail(webSocketFrame)) {
            this.decoder.writeInbound(FRAME_TAIL.duplicate());
        }
        CompositeByteBuf compositeByteBuf = channelHandlerContext.alloc().compositeBuffer();
        while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            compositeByteBuf.addComponent(true, byteBuf);
        }
        if (!bl2 && bl && compositeByteBuf.numComponents() <= 0 && !(webSocketFrame instanceof ContinuationWebSocketFrame)) {
            compositeByteBuf.release();
            throw new CodecException("cannot read uncompressed buffer");
        }
        if (webSocketFrame.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        return compositeByteBuf;
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }
}

