/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundInvoker;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.EmptyHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpClientCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentDecompressor;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObject;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectAggregator;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequestEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpScheme;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketScheme;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class WebSocketClientHandshaker {
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;
    protected final boolean generateOriginHeader;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n) {
        this(uRI, webSocketVersion, string, httpHeaders, n, 10000L);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, false);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, bl, true);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl, boolean bl2) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n;
        this.forceCloseTimeoutMillis = l;
        this.absoluteUpgradeUrl = bl;
        this.generateOriginHeader = bl2;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    public WebSocketClientHandshaker setForceCloseTimeoutMillis(long l) {
        this.forceCloseTimeoutMillis = l;
        return this;
    }

    public ChannelFuture handshake(Channel channel) {
        ObjectUtil.checkNotNull(channel, "channel");
        return this.handshake(channel, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, final ChannelPromise channelPromise) {
        Object object;
        ChannelPipeline channelPipeline = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = channelPipeline.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (object = channelPipeline.get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        if (this.uri.getHost() == null) {
            if (this.customHeaders == null || !this.customHeaders.contains(HttpHeaderNames.HOST)) {
                channelPromise.setFailure(new IllegalArgumentException("Cannot generate the 'host' header value, webSocketURI should contain host or passed through customHeaders"));
                return channelPromise;
            }
            if (this.generateOriginHeader && !this.customHeaders.contains(HttpHeaderNames.ORIGIN)) {
                object = this.version == WebSocketVersion.V07 || this.version == WebSocketVersion.V08 ? HttpHeaderNames.SEC_WEBSOCKET_ORIGIN.toString() : HttpHeaderNames.ORIGIN.toString();
                channelPromise.setFailure(new IllegalArgumentException("Cannot generate the '" + (String)object + "' header value, webSocketURI should contain host or disable generateOriginHeader or pass value through customHeaders"));
                return channelPromise;
            }
        }
        object = this.newHandshakeRequest();
        channel.writeAndFlush(object).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    ChannelPipeline channelPipeline = channelFuture.channel().pipeline();
                    ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpRequestEncoder.class);
                    if (channelHandlerContext == null) {
                        channelHandlerContext = channelPipeline.context(HttpClientCodec.class);
                    }
                    if (channelHandlerContext == null) {
                        channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                        return;
                    }
                    channelPipeline.addAfter(channelHandlerContext.name(), "ws-encoder", WebSocketClientHandshaker.this.newWebSocketEncoder());
                    channelPromise.setSuccess();
                } else {
                    channelPromise.setFailure(channelFuture.cause());
                }
            }
        });
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse fullHttpResponse) {
        ChannelHandlerContext channelHandlerContext;
        HttpObjectAggregator httpObjectAggregator;
        this.verify(fullHttpResponse);
        String string = fullHttpResponse.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string = string != null ? string.trim() : null;
        String string2 = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl = false;
        if (string2.isEmpty() && string == null) {
            bl = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!string2.isEmpty() && string != null && !string.isEmpty()) {
            for (String object2 : string2.split(",")) {
                if (!object2.trim().equals(string)) continue;
                bl = true;
                this.setActualSubprotocol(string);
                break;
            }
        }
        if (!bl) {
            throw new WebSocketClientHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string, this.expectedSubprotocol), fullHttpResponse);
        }
        this.setHandshakeComplete();
        String[] stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove(httpContentDecompressor);
        }
        if ((httpObjectAggregator = stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove(httpObjectAggregator);
        }
        if ((channelHandlerContext = stringArray.context(HttpResponseDecoder.class)) == null) {
            ChannelHandlerContext channelHandlerContext2 = stringArray.context(HttpClientCodec.class);
            if (channelHandlerContext2 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec httpClientCodec = (HttpClientCodec)channelHandlerContext2.handler();
            httpClientCodec.removeOutboundHandler();
            stringArray.addAfter(channelHandlerContext2.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, httpClientCodec){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ HttpClientCodec val$codec;
                {
                    this.val$p = channelPipeline;
                    this.val$codec = httpClientCodec;
                }

                @Override
                public void run() {
                    this.val$p.remove(this.val$codec);
                }
            });
        } else {
            if (stringArray.get(HttpRequestEncoder.class) != null) {
                stringArray.remove(HttpRequestEncoder.class);
            }
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            stringArray.addAfter(channelHandlerContext3.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, channelHandlerContext3){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ ChannelHandlerContext val$context;
                {
                    this.val$p = channelPipeline;
                    this.val$context = channelHandlerContext;
                }

                @Override
                public void run() {
                    this.val$p.remove(this.val$context.handler());
                }
            });
        }
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(final Channel channel, HttpResponse httpResponse, final ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context(HttpClientCodec.class)) == null) {
                return channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            }
            String string = channelHandlerContext.name();
            if (this.version == WebSocketVersion.V00) {
                string = "httpAggregator";
                channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
            }
            channelPipeline.addAfter(string, "handshaker", new ChannelInboundHandlerAdapter(){
                private FullHttpResponse fullHttpResponse;

                @Override
                public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
                    if (object instanceof HttpObject) {
                        try {
                            this.handleHandshakeResponse(channelHandlerContext, (HttpObject)object);
                        }
                        finally {
                            ReferenceCountUtil.release(object);
                        }
                    } else {
                        super.channelRead(channelHandlerContext, object);
                    }
                }

                @Override
                public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
                    channelHandlerContext.pipeline().remove(this);
                    channelPromise.setFailure(throwable);
                }

                @Override
                public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
                    try {
                        if (!channelPromise.isDone()) {
                            channelPromise.tryFailure(new ClosedChannelException());
                        }
                        channelHandlerContext.fireChannelInactive();
                    }
                    finally {
                        this.releaseFullHttpResponse();
                    }
                }

                @Override
                public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
                    this.releaseFullHttpResponse();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void handleHandshakeResponse(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                    if (httpObject instanceof FullHttpResponse) {
                        channelHandlerContext.pipeline().remove(this);
                        this.tryFinishHandshake((FullHttpResponse)httpObject);
                        return;
                    }
                    if (httpObject instanceof LastHttpContent) {
                        assert (this.fullHttpResponse != null);
                        FullHttpResponse fullHttpResponse = this.fullHttpResponse;
                        this.fullHttpResponse = null;
                        try {
                            channelHandlerContext.pipeline().remove(this);
                            this.tryFinishHandshake(fullHttpResponse);
                        }
                        finally {
                            fullHttpResponse.release();
                        }
                        return;
                    }
                    if (httpObject instanceof HttpResponse) {
                        HttpResponse httpResponse = (HttpResponse)httpObject;
                        this.fullHttpResponse = new DefaultFullHttpResponse(httpResponse.protocolVersion(), httpResponse.status(), Unpooled.EMPTY_BUFFER, httpResponse.headers(), EmptyHttpHeaders.INSTANCE);
                        if (httpResponse.decoderResult().isFailure()) {
                            this.fullHttpResponse.setDecoderResult(httpResponse.decoderResult());
                        }
                    }
                }

                private void tryFinishHandshake(FullHttpResponse fullHttpResponse) {
                    try {
                        WebSocketClientHandshaker.this.finishHandshake(channel, fullHttpResponse);
                        channelPromise.setSuccess();
                    }
                    catch (Throwable throwable) {
                        channelPromise.setFailure(throwable);
                    }
                }

                private void releaseFullHttpResponse() {
                    if (this.fullHttpResponse != null) {
                        this.fullHttpResponse.release();
                        this.fullHttpResponse = null;
                    }
                }
            });
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull(channel, "channel");
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channel, "channel");
        return this.close0(channel, channel, closeWebSocketFrame, channelPromise);
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        return this.close(channelHandlerContext, closeWebSocketFrame, channelHandlerContext.newPromise());
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        return this.close0(channelHandlerContext, channelHandlerContext.channel(), closeWebSocketFrame, channelPromise);
    }

    private ChannelFuture close0(final ChannelOutboundInvoker channelOutboundInvoker, final Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        channelOutboundInvoker.writeAndFlush(closeWebSocketFrame, channelPromise);
        final long l = this.forceCloseTimeoutMillis;
        final WebSocketClientHandshaker webSocketClientHandshaker = this;
        if (l <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return channelPromise;
        }
        channelPromise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess() && channel.isActive() && FORCE_CLOSE_INIT_UPDATER.compareAndSet(webSocketClientHandshaker, 0, 1)) {
                    final ScheduledFuture<?> scheduledFuture = channel.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (channel.isActive()) {
                                channelOutboundInvoker.close();
                                WebSocketClientHandshaker.this.forceCloseComplete = true;
                            }
                        }
                    }, l, TimeUnit.MILLISECONDS);
                    channel.closeFuture().addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            scheduledFuture.cancel(false);
                        }
                    });
                }
            }
        });
        return channelPromise;
    }

    protected String upgradeUrl(URI uRI) {
        if (this.absoluteUpgradeUrl) {
            return uRI.toString();
        }
        String string = uRI.getRawPath();
        string = string == null || string.isEmpty() ? "/" : string;
        String string2 = uRI.getRawQuery();
        return string2 != null && !string2.isEmpty() ? string + '?' + string2 : string;
    }

    static CharSequence websocketHostValue(URI uRI) {
        int n = uRI.getPort();
        if (n == -1) {
            return uRI.getHost();
        }
        String string = uRI.getHost();
        String string2 = uRI.getScheme();
        if (n == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals(string2) || WebSocketScheme.WS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n);
        }
        if (n == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals(string2) || WebSocketScheme.WSS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n);
        }
        return NetUtil.toSocketAddressString(string, n);
    }

    static CharSequence websocketOriginValue(URI uRI) {
        int n;
        String string;
        String string2 = uRI.getScheme();
        int n2 = uRI.getPort();
        if (WebSocketScheme.WSS.name().contentEquals(string2) || HttpScheme.HTTPS.name().contentEquals(string2) || string2 == null && n2 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n = WebSocketScheme.WS.port();
        }
        String string3 = uRI.getHost().toLowerCase(Locale.US);
        if (n2 != n && n2 != -1) {
            return string + NetUtil.toSocketAddressString(string3, n2);
        }
        return string + string3;
    }
}

