/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.CombinedChannelDuplexHandler;
import pro.gravit.repackage.io.netty.handler.codec.PrematureChannelClosureException;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequestEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpStatusClass;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;

public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder>
implements HttpClientUpgradeHandler.SourceCodec {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(4096, 8192, 8192, false);
    }

    public HttpClientCodec(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, true);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(n, n2, n3, bl, bl2, false);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.init(new Decoder(n, n2, n3, bl2), new Encoder());
        this.failOnMissingResponse = bl;
        this.parseHttpAfterConnectRequest = bl3;
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this(n, n2, n3, bl, bl2, n4, false);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3) {
        this(n, n2, n3, bl, bl2, n4, bl3, false);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        this(n, n2, n3, bl, bl2, n4, bl3, bl4, true);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4, boolean bl5) {
        this.init(new Decoder(n, n2, n3, bl2, n4, bl4, bl5), new Encoder());
        this.parseHttpAfterConnectRequest = bl3;
        this.failOnMissingResponse = bl;
    }

    @Override
    public void prepareUpgradeFrom(ChannelHandlerContext channelHandlerContext) {
        ((Encoder)this.outboundHandler()).upgraded = true;
    }

    @Override
    public void upgradeFrom(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        channelPipeline.remove(this);
    }

    public void setSingleDecode(boolean bl) {
        ((HttpResponseDecoder)this.inboundHandler()).setSingleDecode(bl);
    }

    public boolean isSingleDecode() {
        return ((HttpResponseDecoder)this.inboundHandler()).isSingleDecode();
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int n, int n2, int n3, boolean bl) {
            super(n, n2, n3, bl);
        }

        Decoder(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
            super(n, n2, n3, bl, n4, bl2, bl3);
        }

        @Override
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            if (HttpClientCodec.this.done) {
                int n = this.actualReadableBytes();
                if (n == 0) {
                    return;
                }
                list.add(byteBuf.readBytes(n));
            } else {
                int n = list.size();
                super.decode(channelHandlerContext, byteBuf, list);
                if (HttpClientCodec.this.failOnMissingResponse) {
                    int n2 = list.size();
                    for (int i = n; i < n2; ++i) {
                        this.decrement(list.get(i));
                    }
                }
            }
        }

        private void decrement(Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            HttpMethod httpMethod = (HttpMethod)HttpClientCodec.this.queue.poll();
            HttpResponseStatus httpResponseStatus = ((HttpResponse)httpMessage).status();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            int n = httpResponseStatus.code();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                return super.isContentAlwaysEmpty(httpMessage);
            }
            if (httpMethod != null) {
                char c = httpMethod.name().charAt(0);
                switch (c) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(httpMethod)) break;
                        return true;
                    }
                    case 'C': {
                        if (n != 200 || !HttpMethod.CONNECT.equals(httpMethod)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.this.done = true;
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(httpMessage);
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            long l;
            super.channelInactive(channelHandlerContext);
            if (HttpClientCodec.this.failOnMissingResponse && (l = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                channelHandlerContext.fireExceptionCaught(new PrematureChannelClosureException("channel gone inactive with " + l + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
            if (this.upgraded) {
                list.add(object);
                return;
            }
            if (object instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)object).method());
            }
            super.encode(channelHandlerContext, object, list);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

