/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.ConnectTimeoutException;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractNioChannel.this.clearReadPending0();
        }
    };
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = n;
        try {
            selectableChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            try {
                selectableChannel.close();
            }
            catch (IOException iOException2) {
                logger.warn("Failed to close a partially initialized socket.", iOException2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public NioUnsafe unsafe() {
        return (NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    @Override
    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    @Deprecated
    protected boolean isReadPending() {
        return this.readPending;
    }

    @Deprecated
    protected void setReadPending(final boolean bl) {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.setReadPending0(bl);
            } else {
                nioEventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractNioChannel.this.setReadPending0(bl);
                    }
                });
            }
        } else {
            this.readPending = bl;
        }
    }

    protected final void clearReadPending() {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.clearReadPending0();
            } else {
                nioEventLoop.execute(this.clearReadPendingRunnable);
            }
        } else {
            this.readPending = false;
        }
    }

    private void setReadPending0(boolean bl) {
        this.readPending = bl;
        if (!bl) {
            ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
        }
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof NioEventLoop;
    }

    @Override
    protected void doRegister() throws Exception {
        boolean bl = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().unwrappedSelector(), 0, this);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl) {
                    this.eventLoop().selectNow();
                    bl = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    @Override
    protected void doDeregister() throws Exception {
        this.eventLoop().cancel(this.selectionKey());
    }

    @Override
    protected void doBeginRead() throws Exception {
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int n = selectionKey.interestOps();
        if ((n & this.readInterestOp) == 0) {
            selectionKey.interestOps(n | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    protected abstract void doFinishConnect() throws Exception;

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf3;
        }
        return byteBuf;
    }

    protected final ByteBuf newDirectBuffer(ReferenceCounted referenceCounted, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf3;
        }
        if (referenceCounted != byteBuf) {
            byteBuf.retain();
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
        return byteBuf;
    }

    @Override
    protected void doClose() throws Exception {
        Future<?> future;
        ChannelPromise channelPromise = this.connectPromise;
        if (channelPromise != null) {
            channelPromise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    protected abstract class AbstractNioUnsafe
    extends AbstractChannel.AbstractUnsafe
    implements NioUnsafe {
        protected AbstractNioUnsafe() {
        }

        protected final void removeReadOp() {
            SelectionKey selectionKey = AbstractNioChannel.this.selectionKey();
            if (!selectionKey.isValid()) {
                return;
            }
            int n = selectionKey.interestOps();
            if ((n & AbstractNioChannel.this.readInterestOp) != 0) {
                selectionKey.interestOps(n & ~AbstractNioChannel.this.readInterestOp);
            }
        }

        @Override
        public final SelectableChannel ch() {
            return AbstractNioChannel.this.javaChannel();
        }

        @Override
        public final void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractNioChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean bl = AbstractNioChannel.this.isActive();
                if (AbstractNioChannel.this.doConnect(socketAddress, socketAddress2)) {
                    this.fulfillConnectPromise(channelPromise, bl);
                } else {
                    AbstractNioChannel.this.connectPromise = channelPromise;
                    AbstractNioChannel.this.requestedRemoteAddress = socketAddress;
                    int n = AbstractNioChannel.this.config().getConnectTimeoutMillis();
                    if (n > 0) {
                        AbstractNioChannel.this.connectTimeoutFuture = (Future)((Object)AbstractNioChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise channelPromise = AbstractNioChannel.this.connectPromise;
                                if (channelPromise != null && !channelPromise.isDone() && channelPromise.tryFailure(new ConnectTimeoutException("connection timed out: " + socketAddress))) {
                                    AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n, TimeUnit.MILLISECONDS));
                    }
                    channelPromise.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (channelFuture.isCancelled()) {
                                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractNioChannel.this.connectPromise = null;
                                AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
                this.closeIfClosed();
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
            if (channelPromise == null) {
                return;
            }
            boolean bl2 = AbstractNioChannel.this.isActive();
            boolean bl3 = channelPromise.trySuccess();
            if (!bl && bl2) {
                AbstractNioChannel.this.pipeline().fireChannelActive();
            }
            if (!bl3) {
                this.close(this.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        @Override
        public final void finishConnect() {
            assert (AbstractNioChannel.this.eventLoop().inEventLoop());
            try {
                boolean bl = AbstractNioChannel.this.isActive();
                AbstractNioChannel.this.doFinishConnect();
                this.fulfillConnectPromise(AbstractNioChannel.this.connectPromise, bl);
            }
            catch (Throwable throwable) {
                this.fulfillConnectPromise(AbstractNioChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractNioChannel.this.requestedRemoteAddress));
            }
            finally {
                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractNioChannel.this.connectPromise = null;
            }
        }

        @Override
        protected final void flush0() {
            if (!this.isFlushPending()) {
                super.flush0();
            }
        }

        @Override
        public final void forceFlush() {
            super.flush0();
        }

        private boolean isFlushPending() {
            SelectionKey selectionKey = AbstractNioChannel.this.selectionKey();
            return selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0;
        }
    }

    public static interface NioUnsafe
    extends Channel.Unsafe {
        public SelectableChannel ch();

        public void finishConnect();

        public void read();

        public void forceFlush();
    }
}

