/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsManager
extends JsonConfigurable<NewLauncherSettings> {
    public static NewLauncherSettings settings;

    public SettingsManager() {
        super((Type)((Object)NewLauncherSettings.class), DirBridge.dir.resolve("settings.json"));
    }

    @Override
    public NewLauncherSettings getConfig() {
        return settings;
    }

    @Override
    public void setConfig(NewLauncherSettings newLauncherSettings) {
        settings = newLauncherSettings;
        if (SettingsManager.settings.consoleUnlockKey != null && !ConsoleManager.isConsoleUnlock && ConsoleManager.checkUnlockKey(SettingsManager.settings.consoleUnlockKey)) {
            ConsoleManager.unlock();
            LogHelper.info("Console auto unlocked");
        }
    }

    @Override
    public NewLauncherSettings getDefaultConfig() {
        return new NewLauncherSettings();
    }

    public void loadHDirStore(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        IOHelper.walk(path, new StoreFileVisitor(), false);
    }

    public void saveHDirStore(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        for (NewLauncherSettings.HashedStoreEntry hashedStoreEntry : SettingsManager.settings.lastHDirs) {
            if (!hashedStoreEntry.needSave) continue;
            Path path2 = path.resolve(hashedStoreEntry.name.concat(".bin"));
            if (!Files.exists(path2, new LinkOption[0])) {
                Files.createFile(path2, new FileAttribute[0]);
            }
            try (HOutput hOutput = new HOutput(IOHelper.newOutput(path2));){
                hOutput.writeString(hashedStoreEntry.name, 128);
                hOutput.writeString(hashedStoreEntry.fullPath, 1024);
                hashedStoreEntry.hdir.write(hOutput);
            }
        }
    }

    public void loadHDirStore() throws IOException {
        this.loadHDirStore(DirBridge.dirStore);
    }

    public void saveHDirStore() throws IOException {
        this.saveHDirStore(DirBridge.dirProjectStore);
    }

    public static class StoreFileVisitor
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            try (HInput hInput = new HInput(IOHelper.newInput(path));){
                String string = hInput.readString(128);
                String string2 = hInput.readString(1024);
                HashedDir hashedDir = new HashedDir(hInput);
                SettingsManager.settings.lastHDirs.add(new NewLauncherSettings.HashedStoreEntry(hashedDir, string, string2));
            }
            catch (IOException iOException) {
                LogHelper.error("Skip file %s exception: %s", path.toAbsolutePath().toString(), iOException.getMessage());
            }
            return super.visitFile(path, basicFileAttributes);
        }
    }
}

