/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.request.Request;

public class StateService {
    private AuthRequestEvent rawAuthResult;
    private List<ClientProfile> profiles;
    private ClientProfile profile;
    private Map<ClientProfile, OptionalView> optionalViewMap;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;

    public void setAuthResult(String string, AuthRequestEvent authRequestEvent) {
        this.rawAuthResult = authRequestEvent;
        if (authRequestEvent.oauth != null) {
            Request.setOAuth(string, authRequestEvent.oauth);
        }
    }

    public void setAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authAvailability = authAvailability;
    }

    public GetAvailabilityAuthRequestEvent.AuthAvailability getAuthAvailability() {
        return this.authAvailability;
    }

    public boolean isSupportedAuthFeature(String string) {
        if (this.authAvailability == null || this.authAvailability.apiFeatures == null) {
            return false;
        }
        return this.authAvailability.apiFeatures.contains(string);
    }

    public String getApiUrl() {
        if (this.authAvailability == null || this.authAvailability.apiUrl == null) {
            return null;
        }
        return this.authAvailability.apiUrl;
    }

    public Map<ClientProfile, OptionalView> getOptionalViewMap() {
        return this.optionalViewMap;
    }

    public void setOptionalView(ClientProfile clientProfile, OptionalView optionalView) {
        this.optionalViewMap.put(clientProfile, optionalView);
    }

    public void setProfilesResult(ProfilesRequestEvent profilesRequestEvent) {
        this.profiles = profilesRequestEvent.profiles;
        this.profiles.sort(ClientProfile::compareTo);
        if (this.optionalViewMap == null) {
            this.optionalViewMap = new HashMap<ClientProfile, OptionalView>();
        }
        for (ClientProfile clientProfile : this.profiles) {
            OptionalView optionalView = this.optionalViewMap.get(clientProfile);
            OptionalView optionalView2 = optionalView != null ? new OptionalView(clientProfile, optionalView) : new OptionalView(clientProfile);
            this.optionalViewMap.put(clientProfile, optionalView2);
        }
    }

    public String getUsername() {
        if (this.rawAuthResult == null || this.rawAuthResult.playerProfile == null) {
            return "Player";
        }
        return this.rawAuthResult.playerProfile.username;
    }

    public String getMainRole() {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null || this.rawAuthResult.permissions.getRoles() == null || this.rawAuthResult.permissions.getRoles().isEmpty()) {
            return "";
        }
        return this.rawAuthResult.permissions.getRoles().get(0);
    }

    public boolean checkPermission(String string) {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null) {
            return false;
        }
        return this.rawAuthResult.permissions.hasPerm(string);
    }

    public List<ClientProfile> getProfiles() {
        return this.profiles;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ClientProfile clientProfile) {
        this.profile = clientProfile;
    }

    public OptionalView getOptionalView() {
        return this.optionalViewMap.get(this.profile);
    }

    public OptionalView getOptionalView(ClientProfile clientProfile) {
        return this.optionalViewMap.get(clientProfile);
    }

    public PlayerProfile getPlayerProfile() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.playerProfile;
    }

    public String getAccessToken() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.accessToken;
    }

    public void exit() {
        this.rawAuthResult = null;
        this.profile = null;
    }
}

