/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaService {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("Java (?<version>.+) b(?<build>.+) (?<os>.+) (?<arch>.+) javafx (?<javafx>.+)");
    public volatile List<JavaHelper.JavaVersion> javaVersions;
    private final JavaFXApplication application;

    public JavaService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
        this.update();
    }

    public void update() {
        LinkedList<JavaHelper.JavaVersion> linkedList = new LinkedList<JavaHelper.JavaVersion>();
        if (this.application.guiModuleConfig.javaList != null) {
            for (Map.Entry<String, String> entry : this.application.guiModuleConfig.javaList.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                Matcher matcher = JAVA_VERSION_PATTERN.matcher(string2);
                if (matcher.matches()) {
                    String string3 = matcher.group("os");
                    int n = Integer.parseInt(matcher.group("version"));
                    int n2 = Integer.parseInt(matcher.group("build"));
                    JVMHelper.ARCH aRCH = JVMHelper.ARCH.valueOf(matcher.group("arch"));
                    boolean bl = Boolean.parseBoolean(matcher.group("javafx"));
                    if (!this.isArchAvailable(aRCH) || !JVMHelper.OS_TYPE.name.equals(string3)) continue;
                    Path path = DirBridge.dirUpdates.resolve(string);
                    LogHelper.debug("In-Launcher Java Version found: Java %d b%d %s javafx %s", n, n2, aRCH.name, Boolean.toString(bl));
                    JavaHelper.JavaVersion javaVersion = new JavaHelper.JavaVersion(path, n, n2, aRCH, bl);
                    linkedList.add(javaVersion);
                    continue;
                }
                LogHelper.warning("Java Version: %s does not match", string2);
            }
        }
        if (!this.application.guiModuleConfig.forceDownloadJava || linkedList.isEmpty()) {
            linkedList.addAll(JavaHelper.findJava());
        }
        this.javaVersions = Collections.unmodifiableList(linkedList);
    }

    public boolean isArchAvailable(JVMHelper.ARCH aRCH) {
        if (JVMHelper.ARCH_TYPE == aRCH) {
            return true;
        }
        if (aRCH == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE && (JVMHelper.ARCH_TYPE == JVMHelper.ARCH.X86 && !JVMHelper.isJVMMatchesSystemArch() || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64)) {
            return true;
        }
        return aRCH == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX && JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64;
    }

    public boolean isIncompatibleJava(JavaHelper.JavaVersion javaVersion, ClientProfile clientProfile) {
        return javaVersion.version > clientProfile.getMaxJavaVersion() || javaVersion.version < clientProfile.getMinJavaVersion();
    }

    public boolean contains(Path path) {
        for (JavaHelper.JavaVersion javaVersion : this.javaVersions) {
            if (!javaVersion.jvmDir.toAbsolutePath().equals(path.toAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public JavaHelper.JavaVersion getRecommendJavaVersion(ClientProfile clientProfile) {
        int n = clientProfile.getMinJavaVersion();
        int n2 = clientProfile.getMaxJavaVersion();
        int n3 = clientProfile.getRecommendJavaVersion();
        JavaHelper.JavaVersion javaVersion = null;
        for (JavaHelper.JavaVersion javaVersion2 : this.javaVersions) {
            if (javaVersion2.version < n || javaVersion2.version > n2 || this.isIncompatibleJava(javaVersion2, clientProfile)) continue;
            if (javaVersion == null) {
                javaVersion = javaVersion2;
                continue;
            }
            if (javaVersion.version != n3 && javaVersion2.version == n3) {
                javaVersion = javaVersion2;
                continue;
            }
            if (javaVersion.version == n3 != (javaVersion2.version == n3)) continue;
            if (javaVersion.version < javaVersion2.version) {
                javaVersion = javaVersion2;
                continue;
            }
            if (javaVersion.arch == JVMHelper.ARCH.X86 && javaVersion2.arch == JVMHelper.ARCH.X86_64 || javaVersion.arch == JVMHelper.ARCH.X86_64 && javaVersion2.arch == JVMHelper.ARCH.ARM64) {
                javaVersion = javaVersion2;
            }
            if (javaVersion.version != javaVersion2.version || javaVersion.build >= javaVersion2.build) continue;
            javaVersion = javaVersion2;
        }
        return javaVersion;
    }
}

