/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.text.Text;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.update.AssetIndexHelper;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionFile;
import pro.gravit.launcher.request.update.UpdateRequest;
import pro.gravit.utils.Downloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class VisualDownloader {
    private final JavaFXApplication application;
    private final AtomicLong totalDownloaded = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong lastDownloaded = new AtomicLong(0L);
    private volatile long totalSize;
    private volatile Downloader downloader;
    private final ProgressBar progressBar;
    private final Text speed;
    private final Label volume;
    private final Consumer<Throwable> errorHandle;
    private final Consumer<String> addLog;
    private final ExecutorService executor;

    public VisualDownloader(JavaFXApplication javaFXApplication, ProgressBar progressBar, Text text, Label label, Consumer<Throwable> consumer, Consumer<String> consumer2) {
        this.application = javaFXApplication;
        this.progressBar = progressBar;
        this.speed = text;
        this.volume = label;
        this.errorHandle = consumer;
        this.addLog = consumer2;
        this.executor = new ForkJoinPool(javaFXApplication.guiModuleConfig.downloadThreads, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(forkJoinPool);
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, null, true);
    }

    public void sendUpdateAssetRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, String string2, Consumer<HashedDir> consumer) {
        if (this.application.offlineService.isOfflineMode()) {
            this.addLog.accept(String.format("Hashing %s", string));
            this.application.workers.submit(() -> {
                try {
                    HashedDir hashedDir = new HashedDir(path, fileNameMatcher, false, bl);
                    consumer.accept(hashedDir);
                }
                catch (IOException iOException) {
                    this.errorHandle.accept(iOException);
                }
            });
            return;
        }
        UpdateRequest updateRequest = new UpdateRequest(string);
        try {
            ((CompletableFuture)this.application.service.request(updateRequest).thenAccept(updateRequestEvent -> {
                LogHelper.dev("Start updating %s", string);
                try {
                    this.downloadAsset(string, path, fileNameMatcher, bl, string2, consumer, updateRequestEvent.hdir, updateRequestEvent.url);
                }
                catch (Exception exception) {
                    ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(exception));
                }
            })).exceptionally(throwable -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(throwable.getCause()));
                return null;
            });
        }
        catch (IOException iOException) {
            this.errorHandle.accept(iOException);
        }
    }

    public void sendUpdateRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, OptionalView optionalView, boolean bl2, Consumer<HashedDir> consumer) {
        if (this.application.offlineService.isOfflineMode()) {
            this.addLog.accept(String.format("Hashing %s", string));
            this.application.workers.submit(() -> {
                try {
                    HashedDir hashedDir = new HashedDir(path, fileNameMatcher, false, bl);
                    consumer.accept(hashedDir);
                }
                catch (IOException iOException) {
                    this.errorHandle.accept(iOException);
                }
            });
            return;
        }
        UpdateRequest updateRequest = new UpdateRequest(string);
        try {
            ((CompletableFuture)this.application.service.request(updateRequest).thenAccept(updateRequestEvent -> {
                LogHelper.dev("Start updating %s", string);
                try {
                    this.download(string, path, fileNameMatcher, bl, optionalView, bl2, consumer, updateRequestEvent.hdir, updateRequestEvent.url);
                }
                catch (Exception exception) {
                    ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(exception));
                }
            })).exceptionally(throwable -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(throwable.getCause()));
                return null;
            });
        }
        catch (IOException iOException) {
            this.errorHandle.accept(iOException);
        }
    }

    private void download(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, OptionalView optionalView, boolean bl2, Consumer<HashedDir> consumer, HashedDir hashedDir, String string2) throws Exception {
        LinkedList<PathRemapperData> linkedList = bl2 ? this.getPathRemapper(optionalView, hashedDir) : new LinkedList();
        this.addLog.accept(String.format("Hashing %s", string));
        if (!IOHelper.exists(path)) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        HashedDir hashedDir2 = new HashedDir(path, fileNameMatcher, false, bl);
        HashedDir.Diff diff = hashedDir.diff(hashedDir2, fileNameMatcher);
        List<AsyncDownloader.SizedFile> list = this.getFilesList(path, linkedList, diff.mismatch);
        LogHelper.info("Diff %d %d", diff.mismatch.size(), diff.extra.size());
        this.addLog.accept(String.format("Downloading %s...", string));
        this.downloadFiles(path, list, string2, () -> {
            try {
                this.addLog.accept(String.format("Delete Extra files %s", string));
                this.deleteExtraDir(path, diff.extra, diff.extra.flag);
                consumer.accept(hashedDir);
            }
            catch (IOException iOException) {
                this.errorHandle.accept(iOException);
            }
        });
    }

    private void downloadAsset(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, String string2, Consumer<HashedDir> consumer, HashedDir hashedDir2, String string3) throws Exception {
        boolean bl2;
        Object object;
        LinkedList linkedList = new LinkedList();
        this.addLog.accept(String.format("Check assetIndex %s", string2));
        if (!IOHelper.exists(path)) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        Consumer<HashedDir> consumer2 = hashedDir -> {
            try {
                HashedDir hashedDir2 = new HashedDir(path, fileNameMatcher, false, bl);
                HashedDir.Diff diff = hashedDir.diff(hashedDir2, fileNameMatcher);
                List<AsyncDownloader.SizedFile> list = this.getFilesList(path, linkedList, diff.mismatch);
                LogHelper.info("Diff %d %d", diff.mismatch.size(), diff.extra.size());
                this.addLog.accept(String.format("Downloading %s...", string));
                this.downloadFiles(path, list, string3, () -> {
                    try {
                        consumer.accept((HashedDir)hashedDir);
                    }
                    catch (Exception exception) {
                        this.errorHandle.accept(exception);
                    }
                });
            }
            catch (Throwable throwable) {
                this.errorHandle.accept(throwable);
            }
        };
        String string4 = "indexes/".concat(string2).concat(".json");
        Path path2 = path.resolve(string4);
        HashedDir.FindRecursiveResult findRecursiveResult = hashedDir2.findRecursive(string4);
        if (!(findRecursiveResult.entry instanceof HashedFile)) {
            this.addLog.accept(String.format("ERROR: assetIndex %s not found", string2));
            this.errorHandle.accept(new RuntimeException("assetIndex not found"));
            return;
        }
        if (Files.exists(path2, new LinkOption[0])) {
            object = new HashedFile(path2, Files.size(path2), true);
            bl2 = !((HashedFile)findRecursiveResult.entry).isSame((HashedFile)object);
        } else {
            IOHelper.createParentDirs(path2);
            bl2 = true;
        }
        if (bl2) {
            object = new ArrayList<AsyncDownloader.SizedFile>(1);
            object.add(new AsyncDownloader.SizedFile(string4, ((HashedFile)findRecursiveResult.entry).size));
            this.downloadFiles(path, (List<AsyncDownloader.SizedFile>)object, string3, () -> {
                try {
                    AssetIndexHelper.AssetIndex assetIndex = AssetIndexHelper.parse(path2);
                    AssetIndexHelper.modifyHashedDir(assetIndex, hashedDir2);
                    consumer2.accept(hashedDir2);
                }
                catch (Exception exception) {
                    this.errorHandle.accept(exception);
                }
            });
        } else {
            try {
                object = AssetIndexHelper.parse(path2);
                AssetIndexHelper.modifyHashedDir(object, hashedDir2);
                consumer2.accept(hashedDir2);
            }
            catch (Exception exception) {
                this.errorHandle.accept(exception);
            }
        }
    }

    private void downloadFiles(Path path, List<AsyncDownloader.SizedFile> list, String string, Runnable runnable) throws Exception {
        ContextHelper.runInFxThreadStatic(this::resetProgress).thenAccept(void_2 -> {
            this.downloader = Downloader.downloadList(list, string, path, new Downloader.DownloadCallback(){

                @Override
                public void apply(long l) {
                    long l2 = VisualDownloader.this.totalDownloaded.getAndAdd(l);
                    VisualDownloader.this.updateProgress(l2, l2 + l);
                }

                @Override
                public void onComplete(Path path) {
                }
            }, this.executor, this.application.guiModuleConfig.downloadThreads);
            ((CompletableFuture)this.downloader.getFuture().thenAccept(void_ -> runnable.run())).exceptionally(throwable -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept((Throwable)throwable));
                return null;
            });
        });
    }

    private void resetProgress() {
        this.totalDownloaded.set(0L);
        this.lastUpdateTime.set(System.currentTimeMillis());
        this.lastDownloaded.set(0L);
        this.progressBar.progressProperty().setValue((Number)0);
    }

    private List<AsyncDownloader.SizedFile> getFilesList(Path path, LinkedList<PathRemapperData> linkedList, HashedDir hashedDir) throws IOException {
        this.totalSize = 0L;
        ArrayList<AsyncDownloader.SizedFile> arrayList = new ArrayList<AsyncDownloader.SizedFile>();
        hashedDir.walk("/", (string, string2, hashedEntry) -> {
            String string3 = string;
            switch (hashedEntry.getType()) {
                case FILE: {
                    HashedFile hashedFile = (HashedFile)hashedEntry;
                    this.totalSize += hashedFile.size;
                    for (PathRemapperData pathRemapperData : linkedList) {
                        if (!string.startsWith(pathRemapperData.key)) continue;
                        string3 = string.replace(pathRemapperData.key, pathRemapperData.value);
                        LogHelper.dev("Remap found: injected url path: %s | calculated original url path: %s", string, string3);
                    }
                    Files.deleteIfExists(path.resolve(string));
                    arrayList.add(new AsyncDownloader.SizedFile(string3, string, hashedFile.size));
                    break;
                }
                case DIR: {
                    Files.createDirectories(path.resolve(string), new FileAttribute[0]);
                }
            }
            return HashedDir.WalkAction.CONTINUE;
        });
        return arrayList;
    }

    private LinkedList<PathRemapperData> getPathRemapper(OptionalView optionalView, HashedDir hashedDir) {
        for (OptionalAction object2 : optionalView.getDisabledActions()) {
            if (!(object2 instanceof OptionalActionFile)) continue;
            ((OptionalActionFile)object2).disableInHashedDir(hashedDir);
        }
        LinkedList linkedList = new LinkedList();
        Set<OptionalActionFile> set = optionalView.getActionsByClass(OptionalActionFile.class);
        for (OptionalActionFile optionalActionFile : set) {
            optionalActionFile.injectToHashedDir(hashedDir);
            optionalActionFile.files.forEach((string, string2) -> {
                if (string2 == null || string2.isEmpty()) {
                    return;
                }
                linkedList.add(new PathRemapperData((String)string2, (String)string));
                LogHelper.dev("Remap prepare %s to %s", string2, string);
            });
        }
        linkedList.sort(Comparator.comparingInt(pathRemapperData -> -pathRemapperData.key.length()));
        return linkedList;
    }

    private void deleteExtraDir(Path path, HashedDir hashedDir, boolean bl) throws IOException {
        block4: for (Map.Entry<String, HashedEntry> entry : hashedDir.map().entrySet()) {
            String string = entry.getKey();
            Path path2 = path.resolve(string);
            HashedEntry hashedEntry = entry.getValue();
            HashedEntry.Type type = hashedEntry.getType();
            switch (type) {
                case FILE: {
                    Files.delete(path2);
                    continue block4;
                }
                case DIR: {
                    this.deleteExtraDir(path2, (HashedDir)hashedEntry, bl || hashedEntry.flag);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
        }
        if (bl) {
            Files.delete(path);
        }
    }

    private void updateProgress(long l, long l2) {
        double d = (double)(l2 - l) / (double)this.totalSize;
        DoubleProperty doubleProperty = this.progressBar.progressProperty();
        doubleProperty.set(doubleProperty.get() + d);
        long l3 = this.lastUpdateTime.get();
        long l4 = System.currentTimeMillis();
        if (l4 - l3 >= 130L) {
            String string = String.format(" [%.1f MB]", (double)l2 / 1048576.0, (double)this.totalSize / 1048576.0);
            double d2 = (double)(l2 - this.lastDownloaded.get()) / (double)(l4 - l3) * 1000.0;
            String string2 = String.format("%.2f ", d2 * 8.0 / 1000000.0);
            ContextHelper.runInFxThreadStatic(() -> {
                this.volume.setText(string);
                this.speed.setText(string2);
            });
            this.lastUpdateTime.set(l4);
            this.lastDownloaded.set(l2);
        }
    }

    public boolean isDownload() {
        return this.downloader != null && !this.downloader.getFuture().isDone();
    }

    public CompletableFuture<Void> getFuture() {
        return this.downloader.getFuture();
    }

    public void cancel() {
        this.downloader.cancel();
    }

    public boolean isCanceled() {
        return this.downloader.isCanceled();
    }

    private static class PathRemapperData {
        public String key;
        public String value;

        public PathRemapperData(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

