/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import java.text.MessageFormat;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;
import oshi.SystemInfo;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsScene
extends AbstractScene {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Pane componentList;
    private Label ramLabel;
    private Slider ramSlider;
    private RuntimeSettings.ProfileSettingsView profileSettings;
    private Button saveButton;
    private ImageView avatar;
    private Image originalAvatarImage;

    public SettingsScene(JavaFXApplication javaFXApplication) {
        super("scenes/settings/settings.fxml", javaFXApplication);
    }

    public void enableSaveButton(String string, EventHandler<ActionEvent> eventHandler) {
        this.saveButton.setVisible(true);
        if (string != null) {
            this.saveButton.setText(string);
        }
        this.saveButton.setOnAction(eventHandler);
    }

    @Override
    protected void doInit() {
        long l;
        SystemInfo systemInfo;
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#clientSettings")).setOnAction(actionEvent -> {
            try {
                if (this.application.stateService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
                this.application.gui.optionsScene.addProfileOptionals(this.application.stateService.getOptionalView());
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.hide()));
        if (this.application.guiModuleConfig.vkURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#vk")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.vkURL));
        }
        if (this.application.guiModuleConfig.dsURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#ds")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.dsURL));
        }
        if (this.application.guiModuleConfig.siteURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#site")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.siteURL));
        }
        if (this.application.guiModuleConfig.forumURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#forum")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forumURL));
        }
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(imageView -> {
            try {
                Rectangle rectangle = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
                rectangle.setArcWidth(imageView.getFitWidth());
                rectangle.setArcHeight(imageView.getFitHeight());
                imageView.setClip((Node)rectangle);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        this.componentList = (Pane)LookupHelper.lookup((Node)this.layout, "#settingslist");
        this.saveButton = (Button)LookupHelper.lookup((Node)this.layout, "#save");
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.layout, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.layout, "#ramLabel");
        try {
            systemInfo = new SystemInfo();
            l = systemInfo.getHardware().getMemory().getTotal() >> 20;
        }
        catch (Throwable throwable) {
            l = 2048L;
        }
        this.ramSlider.setMax((double)Math.min(l, this.getJavaMaxMemory()));
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(true);
        this.ramSlider.setShowTickLabels(true);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double d) {
                return String.format("%.0fG", d / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        systemInfo = (Hyperlink)LookupHelper.lookup((Node)this.layout, "#folder", "#path");
        systemInfo.setText(DirBridge.dirUpdates.toAbsolutePath().toString());
        systemInfo.setOnAction(actionEvent -> this.application.openURL(DirBridge.dirUpdates.toAbsolutePath().toString()));
        this.reset();
    }

    private long getJavaMaxMemory() {
        if (this.application.javaService.isArchAvailable(JVMHelper.ARCH.X86_64) || this.application.javaService.isArchAvailable(JVMHelper.ARCH.ARM64)) {
            return 32768L;
        }
        return 1536L;
    }

    @Override
    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.stateService.getUsername()));
        this.avatar.setImage(this.originalAvatarImage);
        this.profileSettings = new RuntimeSettings.ProfileSettingsView(this.application.getProfileSettings());
        this.ramSlider.setValue((double)this.profileSettings.ram);
        this.ramSlider.valueProperty().addListener((observableValue, number, number2) -> {
            this.profileSettings.ram = number2.intValue();
            this.updateRamLabel();
        });
        this.updateRamLabel();
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
        ClientProfile clientProfile = this.application.stateService.getProfile();
        this.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.profileSettings.apply();
                this.application.triggerManager.process(clientProfile, this.application.stateService.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.componentList.getChildren().clear();
        this.add("Debug", this.profileSettings.debug, bl -> {
            this.profileSettings.debug = bl;
        });
        this.add("Fullscreen", this.profileSettings.fullScreen, bl -> {
            this.profileSettings.fullScreen = bl;
        });
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void add(String string, boolean bl, Consumer<Boolean> consumer) {
        String string2 = String.format("runtime.scenes.settings.properties.%s.name", string.toLowerCase());
        String string3 = String.format("runtime.scenes.settings.properties.%s.description", string.toLowerCase());
        this.add(this.application.getTranslation(string2, string), this.application.getTranslation(string3, string), bl, consumer);
    }

    public void add(String string, String string2, boolean bl, Consumer<Boolean> consumer) {
        VBox vBox = new VBox();
        HBox hBox = new HBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        vBox.getStyleClass().add((Object)"settings-container");
        checkBox.setSelected(bl);
        checkBox.setText(string);
        checkBox.setOnAction(actionEvent -> consumer.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"settings-checkbox");
        label.setText(string2);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"settings-label");
        this.componentList.getChildren().add((Object)vBox);
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.profileSettings.ram == 0 ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.profileSettings.ram));
    }
}

