/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.service.JavaService;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaSelectorComponent {
    private final ComboBox<JavaHelper.JavaVersion> comboBox;
    private final RuntimeSettings.ProfileSettingsView profileSettings;
    private final ClientProfile profile;
    private final JavaService javaService;

    public JavaSelectorComponent(JavaService javaService, Pane pane, RuntimeSettings.ProfileSettingsView profileSettingsView, ClientProfile clientProfile) {
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)pane, "#javaCombo");
        this.profile = clientProfile;
        this.comboBox.getItems().clear();
        this.profileSettings = profileSettingsView;
        this.javaService = javaService;
        this.comboBox.setConverter((StringConverter)new JavaVersionConverter(clientProfile));
        this.reset();
    }

    public void reset() {
        boolean bl = true;
        Object object = this.javaService.javaVersions.iterator();
        while (object.hasNext()) {
            JavaHelper.JavaVersion javaVersion = object.next();
            if (this.javaService.isIncompatibleJava(javaVersion, this.profile)) continue;
            this.comboBox.getItems().add((Object)javaVersion);
            if (this.profileSettings.javaPath == null || !this.profileSettings.javaPath.equals(javaVersion.jvmDir.toString())) continue;
            this.comboBox.setValue((Object)javaVersion);
            bl = false;
        }
        if (bl && (object = this.javaService.getRecommendJavaVersion(this.profile)) != null) {
            LogHelper.warning("Selected Java Version not found. Using %s", ((JavaHelper.JavaVersion)object).jvmDir.toAbsolutePath().toString());
            this.comboBox.getSelectionModel().select(object);
            this.profileSettings.javaPath = ((JavaHelper.JavaVersion)object).jvmDir.toAbsolutePath().toString();
        }
        this.comboBox.setOnAction(actionEvent -> {
            JavaHelper.JavaVersion javaVersion = (JavaHelper.JavaVersion)this.comboBox.getValue();
            if (javaVersion == null) {
                return;
            }
            LogHelper.info("Select Java %s", javaVersion.jvmDir.toAbsolutePath().toString());
        });
    }

    public String getPath() {
        return ((JavaHelper.JavaVersion)this.comboBox.getValue()).jvmDir.toAbsolutePath().toString();
    }

    private static class JavaVersionConverter
    extends StringConverter<JavaHelper.JavaVersion> {
        private final ClientProfile profile;

        private JavaVersionConverter(ClientProfile clientProfile) {
            this.profile = clientProfile;
        }

        public String toString(JavaHelper.JavaVersion javaVersion) {
            if (javaVersion == null) {
                return "Unknown";
            }
            String string = "";
            if (javaVersion.version == this.profile.getRecommendJavaVersion()) {
                string = "[RECOMMENDED]";
            }
            return String.format("Java %d b%d %s", javaVersion.version, javaVersion.build, string);
        }

        public JavaHelper.JavaVersion fromString(String string) {
            return null;
        }
    }
}

