/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.servermenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.client.ServerPinger;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerMenuScene
extends AbstractScene {
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    private ImageView avatar;
    private List<ClientProfile> lastProfiles;
    private Image originalAvatarImage;

    public ServerMenuScene(JavaFXApplication javaFXApplication) {
        super("scenes/servermenu/servermenu.fxml", javaFXApplication);
    }

    @Override
    public void doInit() throws Exception {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.hide()));
        ((Button)LookupHelper.lookup((Node)this.layout, "#textureloader")).setOnMouseClicked(mouseEvent -> {
            try {
                this.showOverlay(this.application.gui.textureLoaderOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.application.gui.textureLoaderOverlay.setOnClose(() -> this.hideOverlay(0.0, null))));
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
        });
        if (this.application.guiModuleConfig.vkURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#vk")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.vkURL));
        }
        if (this.application.guiModuleConfig.dsURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#ds")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.dsURL));
        }
        if (this.application.guiModuleConfig.siteURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#site")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.siteURL));
        }
        if (this.application.guiModuleConfig.forumURL != null) {
            ((Button)LookupHelper.lookup((Node)this.layout, "#forum")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forumURL));
        }
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(imageView -> {
            try {
                Rectangle rectangle = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
                rectangle.setArcWidth(imageView.getFitWidth());
                rectangle.setArcHeight(imageView.getFitHeight());
                imageView.setClip((Node)rectangle);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        scrollPane.setOnScroll(scrollEvent -> {
            double d = scrollEvent.getDeltaY() / scrollPane.getWidth();
            scrollPane.setHvalue(scrollPane.getHvalue() - d);
        });
        this.reset();
        this.isResetOnShow = true;
    }

    public static boolean putAvatarToImageView(JavaFXApplication javaFXApplication, String string, ImageView imageView) {
        int n;
        int n2 = (int)imageView.getFitWidth();
        Image image = javaFXApplication.skinManager.getScaledFxSkinHead(string, n2, n = (int)imageView.getFitHeight());
        if (image == null) {
            return false;
        }
        imageView.setImage(image);
        return true;
    }

    public static ServerButtonComponent getServerButton(JavaFXApplication javaFXApplication, ClientProfile clientProfile) {
        return new ServerButtonComponent(javaFXApplication, clientProfile);
    }

    @Override
    public void reset() {
        ClientProfile clientProfile2;
        if (this.lastProfiles == this.application.stateService.getProfiles()) {
            return;
        }
        this.lastProfiles = this.application.stateService.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> linkedHashMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.stateService.getUsername()));
        this.avatar.setImage(this.originalAvatarImage);
        ArrayList<ClientProfile> arrayList = new ArrayList<ClientProfile>(this.lastProfiles);
        arrayList.sort(Comparator.comparingInt(ClientProfile::getSortIndex).thenComparing(ClientProfile::getTitle));
        int n = 0;
        for (ClientProfile clientProfile2 : arrayList) {
            ServerButtonCache serverButtonCache = new ServerButtonCache();
            serverButtonCache.serverButton = ServerMenuScene.getServerButton(this.application, clientProfile2);
            serverButtonCache.position = n++;
            linkedHashMap.put(clientProfile2, serverButtonCache);
            clientProfile2.updateOptionalGraph();
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        clientProfile2 = (FlowPane)scrollPane.getContent();
        clientProfile2.setHgap(29.0);
        clientProfile2.setVgap(32.0);
        clientProfile2.getChildren().clear();
        this.application.pingService.clear();
        linkedHashMap.forEach((arg_0, arg_1) -> this.lambda$reset$15((FlowPane)clientProfile2, arg_0, arg_1));
        CommonHelper.newThread("ServerPinger", true, () -> {
            for (ClientProfile clientProfile : this.lastProfiles) {
                for (ClientProfile.ServerProfile serverProfile : clientProfile.getServers()) {
                    if (!serverProfile.socketPing || serverProfile.serverAddress == null) continue;
                    try {
                        ServerPinger serverPinger = new ServerPinger(serverProfile, clientProfile.getVersion());
                        ServerPinger.Result result = serverPinger.ping();
                        this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(serverProfile.name, result));
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ClientProfile clientProfile) {
        this.application.stateService.setProfile(clientProfile);
        this.application.runtimeSettings.lastProfile = clientProfile.getUUID();
    }

    private /* synthetic */ void lambda$reset$15(FlowPane flowPane, ClientProfile clientProfile, ServerButtonCache serverButtonCache) {
        EventHandler eventHandler = mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            this.changeServer(clientProfile);
            try {
                this.switchScene(this.application.gui.serverInfoScene);
                this.application.gui.serverInfoScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        };
        serverButtonCache.serverButton.addTo((Pane)flowPane, serverButtonCache.position);
        serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)eventHandler);
    }

    static class ServerButtonCache {
        public ServerButtonComponent serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

