/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;

public class LoginAndPasswordAuthMethod
extends AbstractAuthMethod<AuthPasswordDetails> {
    private final LoginAndPasswordOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginAndPasswordAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.accessor = loginSceneAccessor;
        this.application = loginSceneAccessor.getApplication();
        this.overlay = this.application.gui.registerOverlay(LoginAndPasswordOverlay.class);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthPasswordDetails authPasswordDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthPasswordDetails authPasswordDetails) {
        this.overlay.future = new CompletableFuture();
        String string = this.overlay.login.getText();
        if (this.overlay.password.getText().isEmpty() && this.overlay.password.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.password.saved"))) {
            AuthRequest.AuthPasswordInterface authPasswordInterface = this.application.runtimeSettings.password;
            return CompletableFuture.completedFuture(new LoginScene.LoginAndPasswordResult(string, authPasswordInterface));
        }
        return this.overlay.future;
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.accessor.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        return completableFuture;
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    public static class LoginAndPasswordOverlay
    extends AbstractOverlay {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private TextField password;
        private LoginAuthButtonComponent authButton;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;

        public LoginAndPasswordOverlay(JavaFXApplication javaFXApplication) {
            super("scenes/login/loginpassword.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "loginandpassword";
        }

        @Override
        protected void doInit() {
            LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.close()));
            LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.currentStage.hide()));
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.password = (TextField)LookupHelper.lookup((Node)this.layout, "#password");
            this.authButton = new LoginAuthButtonComponent((Pane)LookupHelper.lookup((Node)this.layout, "#authButtonBlock"), this.application, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                String string = this.login.getText();
                String string2 = this.password.getText();
                this.future.complete(new LoginScene.LoginAndPasswordResult(string, this.accessor.getAuthService().makePassword(string2)));
            }));
            if (this.application.guiModuleConfig.createAccountURL != null) {
                ((Button)LookupHelper.lookup((Node)this.layout, "#register")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
            }
            if (this.application.guiModuleConfig.forgotPassURL != null) {
                ((Button)LookupHelper.lookup((Node)this.layout, "#forgot")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
            }
            if (this.application.runtimeSettings.password != null) {
                this.password.getStyleClass().add((Object)"hasSaved");
                this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password.saved"));
            }
        }

        @Override
        public void reset() {
            if (this.password == null) {
                return;
            }
            this.password.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
            this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password"));
            this.password.setText("");
            this.login.setText("");
        }
    }
}

