/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.client.gui.scenes.login.methods.LoginAndPasswordAuthMethod;
import pro.gravit.launcher.client.gui.service.AuthService;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.launcher.utils.LauncherUpdater;
import pro.gravit.utils.helper.LogHelper;

public class LoginScene
extends AbstractScene {
    public Map<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>> authMethods = new HashMap<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>>(8);
    public boolean isLoginStarted;
    private List<GetAvailabilityAuthRequestEvent.AuthAvailability> auth;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private LoginAuthButtonComponent authButton;
    public boolean needUpdate = false;
    private final AuthService authService = new AuthService(this.application);
    private VBox authList;
    private ToggleGroup authToggleGroup;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private final AuthFlow authFlow = new AuthFlow();
    private volatile boolean processingEnabled = false;

    public LoginScene(JavaFXApplication javaFXApplication) {
        super("scenes/login/login.fxml", javaFXApplication);
        LoginSceneAccessor loginSceneAccessor = new LoginSceneAccessor();
        this.authMethods.put(AuthPasswordDetails.class, new LoginAndPasswordAuthMethod(loginSceneAccessor));
    }

    @Override
    public void doInit() {
        this.authButton = new LoginAuthButtonComponent((Pane)LookupHelper.lookup((Node)this.layout, "#authButtonBlock"), this.application, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.contextHelper.runCallback(this::loginWithGui)));
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword");
        if (this.application.runtimeSettings.password != null || this.application.runtimeSettings.oauthAccessToken != null) {
            ((CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword")).setSelected(true);
        }
        this.autoenter = (CheckBox)LookupHelper.lookup((Node)this.layout, "#autoenter");
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(actionEvent -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        this.authList = (VBox)LookupHelper.lookup((Node)this.layout, "#authList");
        this.authToggleGroup = new ToggleGroup();
        this.authMethods.forEach((clazz, abstractAuthMethod) -> abstractAuthMethod.prepare());
        LauncherRequest launcherRequest = new LauncherRequest();
        GetAvailabilityAuthRequest getAvailabilityAuthRequest = new GetAvailabilityAuthRequest();
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.authAvailability"), getAvailabilityAuthRequest, getAvailabilityAuthRequestEvent -> this.contextHelper.runInFxThread(() -> {
            this.auth = getAvailabilityAuthRequestEvent.list;
            this.authList.setVisible(getAvailabilityAuthRequestEvent.list.size() != 1);
            for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : getAvailabilityAuthRequestEvent.list) {
                if (this.application.runtimeSettings.lastAuth == null) {
                    if (authAvailability.name.equals("std") || this.authAvailability == null) {
                        this.changeAuthAvailability(authAvailability);
                    }
                } else if (authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name)) {
                    this.changeAuthAvailability(authAvailability);
                }
                this.addAuthAvailability(authAvailability);
            }
            if (this.authAvailability == null && getAvailabilityAuthRequestEvent.list.size() > 0) {
                this.changeAuthAvailability(getAvailabilityAuthRequestEvent.list.get(0));
            }
            this.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                if (this.application.runtimeSettings.password != null && this.application.runtimeSettings.autoAuth) {
                    this.contextHelper.runCallback(this::loginWithGui);
                }
                if (this.application.isDebugMode()) {
                    this.postInit();
                }
            }));
        }), null);
        if (!this.application.isDebugMode()) {
            this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.launcher"), launcherRequest, launcherRequestEvent -> {
                if (launcherRequestEvent.launcherExtendedToken != null) {
                    Request.addExtendedToken("launcher", launcherRequestEvent.launcherExtendedToken);
                }
                if (launcherRequestEvent.needUpdate) {
                    try {
                        this.needUpdate = true;
                        LogHelper.debug("Start update processing");
                        this.disable();
                        StdJavaRuntimeProvider.updatePath = LauncherUpdater.prepareUpdate(new URL(launcherRequestEvent.url));
                        LogHelper.debug("Exit with Platform.exit");
                        Platform.exit();
                        this.needUpdate = false;
                        return;
                    }
                    catch (Throwable throwable) {
                        this.contextHelper.runInFxThread(() -> this.errorHandle(throwable));
                        try {
                            Thread.sleep(1500L);
                            LauncherEngine.modulesManager.invokeEvent(new ClientExitPhase(0));
                            Platform.exit();
                        }
                        catch (Throwable throwable2) {
                            LauncherEngine.exitLauncher(0);
                        }
                    }
                }
                LogHelper.dev("Launcher update processed");
                this.postInit();
            }, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> LauncherEngine.exitLauncher(0)));
        }
    }

    private void postInit() {
        this.contextHelper.runInFxThread(this::loginWithGui);
    }

    public void changeAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authAvailability = authAvailability;
        this.authFlow.init(authAvailability);
        LogHelper.info("Selected auth: %s", authAvailability.name);
    }

    public void addAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        RadioButton radioButton = new RadioButton();
        radioButton.setToggleGroup(this.authToggleGroup);
        radioButton.setId("authRadio");
        radioButton.setText(authAvailability.displayName);
        if (this.authAvailability == authAvailability) {
            radioButton.fire();
        }
        radioButton.setOnAction(actionEvent -> this.changeAuthAvailability(authAvailability));
        LogHelper.info("Added %s: %s", authAvailability.name, authAvailability.displayName);
        this.authList.getChildren().add((Object)radioButton);
    }

    public <T extends WebSocketEvent> void processing(Request<T> request, String string, Consumer<T> consumer, Consumer<String> consumer2) {
        Pane pane = (Pane)this.scene.getRoot();
        LookupHelper.Point2D point2D = LookupHelper.getAbsoluteCords((Node)this.authButton.getLayout(), (Node)this.layout);
        LogHelper.debug("X: %f, Y: %f", point2D.x, point2D.y);
        double d = this.authButton.getLayout().getLayoutX();
        double d2 = this.authButton.getLayout().getLayoutY();
        String string2 = this.authButton.getText();
        if (!this.processingEnabled) {
            this.contextHelper.runInFxThread(() -> {
                this.disable();
                this.layout.getChildren().remove((Object)this.authButton.getLayout());
                pane.getChildren().add((Object)this.authButton.getLayout());
                this.authButton.getLayout().setLayoutX(point2D.x);
                this.authButton.getLayout().setLayoutY(point2D.y);
            });
            this.authButton.disable();
            this.processingEnabled = true;
        }
        this.contextHelper.runInFxThread(() -> this.authButton.setText(string));
        Runnable runnable = () -> {
            if (!this.processingEnabled) {
                return;
            }
            this.contextHelper.runInFxThread(() -> {
                this.enable();
                pane.getChildren().remove((Object)this.authButton.getLayout());
                this.layout.getChildren().add((Object)this.authButton.getLayout());
                this.authButton.getLayout().setLayoutX(d);
                this.authButton.getLayout().setLayoutY(d2);
                this.authButton.setText(string2);
            });
            this.authButton.enable();
            this.processingEnabled = false;
        };
        try {
            ((CompletableFuture)this.application.service.request(request).thenAccept(webSocketEvent -> {
                consumer.accept(webSocketEvent);
                runnable.run();
            })).exceptionally(throwable -> {
                consumer2.accept(throwable.getCause().getMessage());
                runnable.run();
                return null;
            });
        }
        catch (IOException iOException) {
            runnable.run();
            this.errorHandle(iOException);
        }
    }

    @Override
    public void errorHandle(Throwable throwable) {
        super.errorHandle(throwable);
        Pane pane = (Pane)this.scene.getRoot();
        double d = this.authButton.getLayout().getLayoutX();
        double d2 = this.authButton.getLayout().getLayoutY();
        if (!this.processingEnabled) {
            return;
        }
        this.contextHelper.runInFxThread(() -> {
            this.enable();
            pane.getChildren().remove((Object)this.authButton.getLayout());
            this.layout.getChildren().add((Object)this.authButton.getLayout());
            this.authButton.getLayout().setLayoutX(d);
            this.authButton.getLayout().setLayoutY(d2);
            this.authButton.setText("ERROR");
        });
        this.authButton.enable();
        this.processingEnabled = false;
    }

    @Override
    public void reset() {
        this.contextHelper.runInFxThread(this::loginWithGui);
    }

    @Override
    public String getName() {
        return "login";
    }

    private boolean tryOAuthLogin() {
        if (this.application.runtimeSettings.lastAuth != null && this.authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name) && this.application.runtimeSettings.oauthAccessToken != null) {
            if (this.application.runtimeSettings.oauthExpire != 0L && this.application.runtimeSettings.oauthExpire < System.currentTimeMillis()) {
                RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(this.authAvailability.name, this.application.runtimeSettings.oauthRefreshToken);
                this.processing(refreshTokenRequest, this.application.getTranslation("runtime.overlay.processing.text.auth"), refreshTokenRequestEvent -> {
                    this.application.runtimeSettings.oauthAccessToken = refreshTokenRequestEvent.oauth.accessToken;
                    this.application.runtimeSettings.oauthRefreshToken = refreshTokenRequestEvent.oauth.refreshToken;
                    this.application.runtimeSettings.oauthExpire = refreshTokenRequestEvent.oauth.expire == 0L ? 0L : System.currentTimeMillis() + refreshTokenRequestEvent.oauth.expire;
                    Request.setOAuth(this.authAvailability.name, refreshTokenRequestEvent.oauth);
                    AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(this.application.runtimeSettings.oauthAccessToken);
                    LogHelper.info("Login with OAuth AccessToken");
                    this.loginWithOAuth(authOAuthPassword, this.authAvailability);
                }, string -> {
                    this.application.runtimeSettings.oauthAccessToken = null;
                    this.application.runtimeSettings.oauthRefreshToken = null;
                    this.contextHelper.runInFxThread(this::loginWithGui);
                });
                return true;
            }
            Request.setOAuth(this.authAvailability.name, new AuthRequestEvent.OAuthRequestEvent(this.application.runtimeSettings.oauthAccessToken, this.application.runtimeSettings.oauthRefreshToken, this.application.runtimeSettings.oauthExpire), this.application.runtimeSettings.oauthExpire);
            AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(this.application.runtimeSettings.oauthAccessToken);
            LogHelper.info("Login with OAuth AccessToken");
            this.loginWithOAuth(authOAuthPassword, this.authAvailability);
            return true;
        }
        return false;
    }

    private void loginWithOAuth(AuthOAuthPassword authOAuthPassword, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        AuthRequest authRequest = this.authService.makeAuthRequest(null, authOAuthPassword, authAvailability.name);
        this.processing(authRequest, this.application.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> this.contextHelper.runInFxThread(() -> this.onSuccessLogin(new SuccessAuth((AuthRequestEvent)authRequestEvent, null, null))), string -> {
            if (string.equals("auth.invalidtoken")) {
                this.application.runtimeSettings.oauthAccessToken = null;
                this.application.runtimeSettings.oauthRefreshToken = null;
            } else {
                this.errorHandle(new RequestException((String)string));
            }
        });
    }

    private AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> detailsToMethod(GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails) {
        return this.authMethods.get(authAvailabilityDetails.getClass());
    }

    private void loginWithGui() {
        if (this.tryOAuthLogin()) {
            return;
        }
        this.authFlow.start().thenAccept(successAuth -> this.contextHelper.runInFxThread(() -> this.onSuccessLogin((SuccessAuth)successAuth)));
    }

    private boolean checkSavePasswordAvailable(AuthRequest.AuthPasswordInterface authPasswordInterface) {
        if (authPasswordInterface instanceof Auth2FAPassword) {
            return false;
        }
        if (authPasswordInterface instanceof AuthMultiPassword) {
            return false;
        }
        return this.authAvailability != null && this.authAvailability.details != null && this.authAvailability.details.size() != 0 && this.authAvailability.details.get(0) instanceof AuthPasswordDetails;
    }

    private void onSuccessLogin(SuccessAuth successAuth) {
        AuthRequestEvent authRequestEvent = successAuth.requestEvent;
        this.application.stateService.setAuthResult(this.authAvailability.name, authRequestEvent);
        boolean bl = this.savePasswordCheckBox.isSelected();
        if (bl) {
            this.application.runtimeSettings.login = successAuth.recentLogin;
            if (authRequestEvent.oauth == null) {
                if (successAuth.recentPassword != null && this.checkSavePasswordAvailable(successAuth.recentPassword)) {
                    this.application.runtimeSettings.password = successAuth.recentPassword;
                } else {
                    LogHelper.warning("2FA/MFA Password not saved");
                }
            } else {
                this.application.runtimeSettings.oauthAccessToken = authRequestEvent.oauth.accessToken;
                this.application.runtimeSettings.oauthRefreshToken = authRequestEvent.oauth.refreshToken;
                this.application.runtimeSettings.oauthExpire = Request.getTokenExpiredTime();
            }
            this.application.runtimeSettings.lastAuth = this.authAvailability;
        }
        if (authRequestEvent.playerProfile != null && authRequestEvent.playerProfile.assets != null && authRequestEvent.playerProfile.assets.get("SKIN") != null) {
            try {
                this.application.skinManager.addSkin(authRequestEvent.playerProfile.username, new URL(authRequestEvent.playerProfile.assets.get((Object)"SKIN").url));
                this.application.skinManager.getSkin(authRequestEvent.playerProfile.username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.contextHelper.runInFxThread(() -> {
            Optional optional = LookupHelper.lookupIfPossible((Node)this.scene.getRoot(), "#player");
            if (optional.isPresent()) {
                LookupHelper.lookupIfPossible((Node)optional.get(), "#playerName").ifPresent(label -> label.setText(this.application.stateService.getUsername()));
                LookupHelper.lookupIfPossible((Node)optional.get(), "#playerHead").ifPresent(imageView -> {
                    try {
                        Rectangle rectangle = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
                        rectangle.setArcWidth(imageView.getFitWidth());
                        rectangle.setArcHeight(imageView.getFitHeight());
                        imageView.setClip((Node)rectangle);
                        Image image = this.application.skinManager.getScaledFxSkinHead(authRequestEvent.playerProfile.username, (int)imageView.getFitWidth(), (int)imageView.getFitHeight());
                        if (image != null) {
                            imageView.setImage(image);
                        }
                    }
                    catch (Throwable throwable) {
                        LogHelper.warning("Skin head error");
                    }
                });
                ((Node)optional.get()).setVisible(true);
                this.disable();
                LoginScene.fade((Node)optional.get(), 2000.0, 0.0, 1.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                    this.enable();
                    this.onGetProfiles();
                    ((Node)optional.get()).setVisible(false);
                }));
            } else {
                this.onGetProfiles();
            }
        });
    }

    public void onGetProfiles() {
        this.processing(new ProfilesRequest(), this.application.getTranslation("runtime.overlay.processing.text.profiles"), profilesRequestEvent -> {
            this.application.stateService.setProfilesResult((ProfilesRequestEvent)profilesRequestEvent);
            this.application.runtimeSettings.profiles = profilesRequestEvent.profiles;
            for (ClientProfile clientProfile : profilesRequestEvent.profiles) {
                this.application.triggerManager.process(clientProfile, this.application.stateService.getOptionalView(clientProfile));
            }
            this.contextHelper.runInFxThread(() -> {
                this.hideOverlay(0.0, null);
                this.application.securityService.startRequest();
                if (this.application.gui.optionsScene != null) {
                    try {
                        this.application.gui.optionsScene.loadAll();
                    }
                    catch (Throwable throwable) {
                        this.errorHandle(throwable);
                    }
                }
                if (this.application.getCurrentScene() instanceof LoginScene) {
                    ((LoginScene)this.application.getCurrentScene()).isLoginStarted = false;
                }
                this.application.setMainScene(this.application.gui.serverMenuScene);
            });
        }, null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.encryptedPassword = null;
        this.application.runtimeSettings.password = null;
        this.application.runtimeSettings.login = null;
        this.application.runtimeSettings.oauthAccessToken = null;
        this.application.runtimeSettings.oauthRefreshToken = null;
    }

    public static class SuccessAuth {
        public AuthRequestEvent requestEvent;
        public String recentLogin;
        public AuthRequest.AuthPasswordInterface recentPassword;

        public SuccessAuth(AuthRequestEvent authRequestEvent, String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            this.requestEvent = authRequestEvent;
            this.recentLogin = string;
            this.recentPassword = authPasswordInterface;
        }
    }

    public class AuthFlow {
        private final List<Integer> authFlow = new ArrayList<Integer>();
        private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;

        public void init(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
            this.authAvailability = authAvailability;
            this.authFlow.clear();
            this.authFlow.add(0);
        }

        private CompletableFuture<LoginAndPasswordResult> tryLogin(String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            CompletionStage<LoginAndPasswordResult> completionStage = null;
            if (authPasswordInterface != null) {
                completionStage = new CompletableFuture<LoginAndPasswordResult>();
                completionStage.complete(new LoginAndPasswordResult(string, authPasswordInterface));
            }
            for (int n : this.authFlow) {
                GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails = this.authAvailability.details.get(n);
                AbstractAuthMethod abstractAuthMethod = LoginScene.this.detailsToMethod(authAvailabilityDetails);
                if (completionStage == null) {
                    completionStage = abstractAuthMethod.show(authAvailabilityDetails).thenCompose(void_ -> abstractAuthMethod.auth(authAvailabilityDetails));
                } else {
                    completionStage = completionStage.thenCompose(loginAndPasswordResult -> abstractAuthMethod.show(authAvailabilityDetails).thenApply(void_ -> loginAndPasswordResult));
                    completionStage = completionStage.thenCompose(loginAndPasswordResult -> abstractAuthMethod.auth(authAvailabilityDetails).thenApply(loginAndPasswordResult2 -> {
                        AuthRequest.AuthPasswordInterface authPasswordInterface;
                        String string = null;
                        if (loginAndPasswordResult.login != null) {
                            string = loginAndPasswordResult.login;
                        }
                        if (loginAndPasswordResult2.login != null) {
                            string = loginAndPasswordResult2.login;
                        }
                        if (loginAndPasswordResult.password instanceof AuthMultiPassword) {
                            authPasswordInterface = loginAndPasswordResult.password;
                            ((AuthMultiPassword)authPasswordInterface).list.add(loginAndPasswordResult2.password);
                        } else if (loginAndPasswordResult.password instanceof Auth2FAPassword) {
                            authPasswordInterface = new AuthMultiPassword();
                            ((AuthMultiPassword)authPasswordInterface).list = new ArrayList<AuthRequest.AuthPasswordInterface>();
                            ((AuthMultiPassword)authPasswordInterface).list.add(((Auth2FAPassword)loginAndPasswordResult.password).firstPassword);
                            ((AuthMultiPassword)authPasswordInterface).list.add(((Auth2FAPassword)loginAndPasswordResult.password).secondPassword);
                            ((AuthMultiPassword)authPasswordInterface).list.add(loginAndPasswordResult2.password);
                        } else {
                            authPasswordInterface = new Auth2FAPassword();
                            ((Auth2FAPassword)authPasswordInterface).firstPassword = loginAndPasswordResult.password;
                            ((Auth2FAPassword)authPasswordInterface).secondPassword = loginAndPasswordResult2.password;
                        }
                        return new LoginAndPasswordResult(string, authPasswordInterface);
                    }));
                }
                completionStage = completionStage.thenCompose(loginAndPasswordResult -> abstractAuthMethod.hide().thenApply(void_ -> loginAndPasswordResult));
            }
            return completionStage;
        }

        private void start(CompletableFuture<SuccessAuth> completableFuture, String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            CompletableFuture<LoginAndPasswordResult> completableFuture2 = this.tryLogin(string, authPasswordInterface);
            ((CompletableFuture)completableFuture2.thenAccept(loginAndPasswordResult -> this.login(loginAndPasswordResult.login, loginAndPasswordResult.password, this.authAvailability, completableFuture))).exceptionally(throwable -> {
                throwable = throwable.getCause();
                LoginScene.this.isLoginStarted = false;
                if (throwable instanceof AbstractAuthMethod.UserAuthCanceledException) {
                    return null;
                }
                LoginScene.this.errorHandle((Throwable)throwable);
                return null;
            });
        }

        private CompletableFuture<SuccessAuth> start() {
            CompletableFuture<SuccessAuth> completableFuture = new CompletableFuture<SuccessAuth>();
            this.start(completableFuture, null, null);
            return completableFuture;
        }

        private void login(String string, AuthRequest.AuthPasswordInterface authPasswordInterface, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, CompletableFuture<SuccessAuth> completableFuture) {
            LoginScene.this.isLoginStarted = true;
            LogHelper.dev("Auth with %s password ***** authId %s", string, authAvailability);
            AuthRequest authRequest = LoginScene.this.authService.makeAuthRequest(string, authPasswordInterface, authAvailability.name);
            LoginScene.this.processing(authRequest, LoginScene.this.application.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> completableFuture.complete(new SuccessAuth((AuthRequestEvent)authRequestEvent, string, authPasswordInterface)), string2 -> {
                if (string2.equals("auth.invalidtoken")) {
                    ((LoginScene)LoginScene.this).application.runtimeSettings.oauthAccessToken = null;
                    ((LoginScene)LoginScene.this).application.runtimeSettings.oauthRefreshToken = null;
                    completableFuture.completeExceptionally(new RequestException((String)string2));
                } else if (string2.equals("auth.require2fa")) {
                    this.authFlow.clear();
                    this.authFlow.add(1);
                    LoginScene.this.contextHelper.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
                } else if (string2.startsWith("auth.require.factor.")) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (String string3 : string2.substring("auth.require.factor.".length() + 1).split("\\.")) {
                        arrayList.add(Integer.parseInt(string3));
                    }
                    this.authFlow.clear();
                    this.authFlow.addAll(arrayList);
                    LoginScene.this.contextHelper.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
                } else {
                    this.authFlow.clear();
                    this.authFlow.add(0);
                    LoginScene.this.errorHandle(new RequestException((String)string2));
                    LoginScene.this.contextHelper.runInFxThread(() -> LoginScene.this.loginWithGui());
                }
            });
        }
    }

    public class LoginSceneAccessor {
        public void showOverlay(AbstractOverlay abstractOverlay, EventHandler<ActionEvent> eventHandler) throws Exception {
            LoginScene.this.showOverlay(abstractOverlay, eventHandler);
        }

        public void hideOverlay(double d, EventHandler<ActionEvent> eventHandler) {
            LoginScene.this.hideOverlay(d, eventHandler);
        }

        public AuthService getAuthService() {
            return LoginScene.this.authService;
        }

        public JavaFXApplication getApplication() {
            return LoginScene.this.application;
        }

        public void errorHandle(Throwable throwable) {
            LoginScene.this.errorHandle(throwable);
        }
    }

    public static class LoginAndPasswordResult {
        public final String login;
        public final AuthRequest.AuthPasswordInterface password;

        public LoginAndPasswordResult(String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            this.login = string;
            this.password = authPasswordInterface;
        }
    }
}

