/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractScene
extends AbstractVisualComponent {
    protected final LauncherConfig launcherConfig;
    protected Scene scene;
    protected Pane header;
    protected Pane disablePane;
    private volatile Node currentOverlayNode;
    private volatile AbstractOverlay currentOverlay;
    private AtomicInteger enabled = new AtomicInteger(0);
    private volatile boolean hideTransformStarted = false;

    protected AbstractScene(String string, JavaFXApplication javaFXApplication) {
        super(string, javaFXApplication);
        this.launcherConfig = Launcher.getConfig();
    }

    protected AbstractStage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void init() throws Exception {
        if (this.scene == null) {
            this.scene = new Scene(this.getFxmlRoot());
            this.scene.setFill((Paint)Color.TRANSPARENT);
        }
        this.layout = (Pane)LookupHelper.lookupIfPossible((Node)this.scene.getRoot(), "#layout").orElse(this.scene.getRoot());
        Rectangle rectangle = new Rectangle(this.layout.getPrefWidth(), this.layout.getPrefHeight());
        rectangle.setArcHeight(4.0);
        rectangle.setArcWidth(4.0);
        this.layout.setClip((Node)rectangle);
        this.header = LookupHelper.lookupIfPossible((Node)this.layout, "#header").orElse(null);
        this.sceneBaseInit();
        super.init();
    }

    @Override
    protected abstract void doInit() throws Exception;

    public void showOverlay(AbstractOverlay abstractOverlay, EventHandler<ActionEvent> eventHandler) throws Exception {
        this.currentOverlay = abstractOverlay;
        this.currentOverlay.show(this.currentStage);
        this.showOverlay(abstractOverlay.getLayout(), eventHandler);
    }

    private void showOverlay(Pane pane, EventHandler<ActionEvent> eventHandler) {
        if (pane == null) {
            throw new NullPointerException();
        }
        if (this.currentOverlayNode != null) {
            this.swapOverlay(pane, eventHandler);
            return;
        }
        this.currentOverlayNode = pane;
        Pane pane2 = (Pane)this.scene.getRoot();
        this.disable();
        pane2.getChildren().add((Object)pane);
        pane.setLayoutX((pane2.getPrefWidth() - pane.getPrefWidth()) / 2.0);
        pane.setLayoutY((pane2.getPrefHeight() - pane.getPrefHeight()) / 2.0);
        pane.toFront();
        pane.requestFocus();
        AbstractScene.fade((Node)pane, 0.0, 0.0, 1.0, eventHandler);
    }

    public void hideOverlay(double d, EventHandler<ActionEvent> eventHandler) {
        if (this.currentOverlayNode == null) {
            return;
        }
        if (this.currentOverlay == null) {
            return;
        }
        if (this.hideTransformStarted && eventHandler != null) {
            this.contextHelper.runInFxThread(() -> eventHandler.handle(null));
        }
        this.hideTransformStarted = true;
        Pane pane = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, d, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            pane.getChildren().remove((Object)this.currentOverlayNode);
            pane.requestFocus();
            this.enable();
            this.currentOverlayNode = null;
            if (this.currentOverlay != null) {
                this.currentOverlay.reset();
            }
            this.currentOverlay = null;
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
            this.hideTransformStarted = false;
        }));
    }

    private void swapOverlay(Pane pane, EventHandler<ActionEvent> eventHandler) {
        if (this.currentOverlayNode == null) {
            throw new IllegalStateException("Try swap null overlay");
        }
        if (this.hideTransformStarted && eventHandler != null) {
            this.contextHelper.runInFxThread(() -> eventHandler.handle(null));
        }
        this.hideTransformStarted = true;
        Pane pane2 = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, 0.0, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent2 -> {
            if (this.currentOverlayNode != pane) {
                ObservableList observableList = pane2.getChildren();
                int n = observableList.indexOf((Object)this.currentOverlayNode);
                observableList.set(n, (Object)pane);
            }
            pane.setLayoutX((pane2.getPrefWidth() - pane.getPrefWidth()) / 2.0);
            pane.setLayoutY((pane2.getPrefHeight() - pane.getPrefHeight()) / 2.0);
            this.currentOverlayNode = pane;
            pane.toFront();
            pane.requestFocus();
            AbstractScene.fade((Node)pane, 0.0, 0.0, 1.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                this.hideTransformStarted = false;
                if (eventHandler != null) {
                    eventHandler.handle(actionEvent);
                }
            }));
        }));
    }

    protected final <T extends WebSocketEvent> void processRequest(String string, Request<T> request, Consumer<T> consumer, EventHandler<ActionEvent> eventHandler) {
        this.application.gui.processingOverlay.processRequest(this, string, request, consumer, eventHandler);
    }

    protected final <T extends WebSocketEvent> void processRequest(String string, Request<T> request, Consumer<T> consumer, Consumer<Throwable> consumer2, EventHandler<ActionEvent> eventHandler) {
        this.application.gui.processingOverlay.processRequest(this, string, request, consumer, consumer2, eventHandler);
    }

    public AbstractOverlay getCurrentOverlay() {
        return this.currentOverlay;
    }

    @Override
    public void disable() {
        LogHelper.debug("Scene %s disabled (%d)", this.getName(), this.enabled.incrementAndGet());
        if (this.enabled.get() != 1) {
            return;
        }
        Pane pane = (Pane)this.scene.getRoot();
        if (this.layout == pane) {
            throw new IllegalStateException("AbstractScene.disable() failed: layout == root");
        }
        this.layout.setEffect((Effect)new GaussianBlur(2.0));
        if (this.disablePane == null) {
            this.disablePane = new Pane();
            this.disablePane.setPrefHeight(pane.getPrefHeight());
            this.disablePane.setPrefWidth(pane.getPrefWidth());
            int n = pane.getChildren().indexOf((Object)this.layout);
            pane.getChildren().add(n + 1, (Object)this.disablePane);
        }
        this.disablePane.setVisible(true);
    }

    @Override
    public void enable() {
        LogHelper.debug("Scene %s enabled (%d)", this.getName(), this.enabled.decrementAndGet());
        if (this.enabled.get() != 0) {
            return;
        }
        this.layout.setEffect((Effect)new GaussianBlur(0.0));
        this.disablePane.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled.get() == 0;
    }

    @Override
    public abstract void reset();

    public Scene getScene() {
        return this.scene;
    }

    private void sceneBaseInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#deauth").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.exitDialog.header"), this.application.getTranslation("runtime.scenes.settings.exitDialog.description"), this::userExit, () -> {}, true)));
        this.currentStage.enableMouseDrag((Node)this.layout);
    }

    private ContextMenu makeLangContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getStyleClass().add((Object)"langChoice");
        for (RuntimeSettings.LAUNCHER_LOCALE lAUNCHER_LOCALE : RuntimeSettings.LAUNCHER_LOCALE.values()) {
            MenuItem menuItem = new MenuItem(lAUNCHER_LOCALE.displayName);
            menuItem.setOnAction(actionEvent -> {
                try {
                    this.application.updateLocaleResources(lAUNCHER_LOCALE.name);
                    this.application.runtimeSettings.locale = lAUNCHER_LOCALE;
                    this.application.gui.reload();
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
            });
            contextMenu.getItems().add((Object)menuItem);
        }
        return contextMenu;
    }

    protected void userExit() {
        this.processRequest(this.application.getTranslation("runtime.scenes.settings.exitDialog.processing"), new ExitRequest(), exitRequestEvent -> ContextHelper.runInFxThreadStatic(() -> {
            this.hideOverlay(0.0, null);
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.saveSettings();
                this.application.stateService.exit();
                this.switchScene(this.application.gui.loginScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {}));
    }

    protected void switchScene(AbstractScene abstractScene) throws Exception {
        this.currentStage.setScene(abstractScene);
    }

    public Node getHeader() {
        return this.header;
    }

    public static void runLater(double d, EventHandler<ActionEvent> eventHandler) {
        AbstractScene.fade(null, d, 0.0, 1.0, eventHandler);
    }
}

