/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlays;

import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.utils.helper.LogHelper;

public class TextureLoaderOverlay
extends AbstractOverlay {
    private Runnable onClose;

    public TextureLoaderOverlay(JavaFXApplication javaFXApplication) {
        super("overlay/textureloader/textureloader.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "TextureLoader";
    }

    @Override
    protected void doInit() {
        ((Button)LookupHelper.lookup((Node)this.layout, "#close")).setOnAction(actionEvent -> this.onClose.run());
        ((Button)LookupHelper.lookup((Node)this.layout, "#upload_skin")).setOnAction(actionEvent -> {
            try {
                this.uploadTexture("skin");
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#upload_cape")).setOnAction(actionEvent -> {
            try {
                this.uploadTexture("cape");
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
        });
    }

    @Override
    public void reset() {
    }

    public void setOnClose(Runnable runnable) {
        this.onClose = runnable;
    }

    private void uploadTexture(String string) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(new File("/"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.application.getTranslation("runtime.overlay.textureloader." + string + ".select"), new String[]{"*.png"}));
        File file = fileChooser.showOpenDialog((Window)this.application.getMainStage().stage);
        if (file != null) {
            try (Response response = new OkHttpClient().newCall(new Request.Builder().addHeader("authorization", "Bearer " + this.application.runtimeSettings.oauthAccessToken).url(this.application.guiModuleConfig.textureLoaderURL).post(new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("type", string).addFormDataPart("upload_texture", file.getName(), RequestBody.create(MediaType.parse("image/png"), file)).build()).build()).execute();){
                String string2 = response.body() != null ? response.body().string() : "";
                this.application.messageManager.createNotification("INFO", string2);
                LogHelper.debug(string2);
            }
            catch (Exception exception) {
                this.application.messageManager.createNotification("ERROR", exception.getLocalizedMessage());
                LogHelper.error(exception.getLocalizedMessage());
            }
            this.onClose.run();
        }
    }
}

