/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.UUID;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.client.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.utils.helper.LogHelper;

public class GuiEventHandler
implements RequestService.EventHandler {
    private final JavaFXApplication application;

    public GuiEventHandler(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    @Override
    public <T extends WebSocketEvent> boolean eventHandle(T t) {
        block9: {
            LogHelper.dev("Processing event %s", t.getType());
            if (t instanceof RequestEvent && !((RequestEvent)t).requestUUID.equals(RequestEvent.eventUUID)) {
                return false;
            }
            try {
                AbstractScene abstractScene;
                if (t instanceof AuthRequestEvent) {
                    boolean bl = this.application.getCurrentScene() instanceof LoginScene;
                    ((LoginScene)this.application.getCurrentScene()).isLoginStarted = true;
                    LogHelper.dev("Receive auth event. Send next scene %s", bl ? "true" : "false");
                    this.application.stateService.setAuthResult(null, (AuthRequestEvent)t);
                    if (bl && ((LoginScene)this.application.getCurrentScene()).isLoginStarted) {
                        ((LoginScene)this.application.getCurrentScene()).onGetProfiles();
                    }
                }
                if (!(t instanceof ProfilesRequestEvent)) break block9;
                this.application.stateService.setProfilesResult((ProfilesRequestEvent)t);
                if (this.application.stateService.getProfile() != null) {
                    UUID uUID = this.application.stateService.getProfile().getUUID();
                    for (ClientProfile clientProfile : this.application.stateService.getProfiles()) {
                        if (!clientProfile.getUUID().equals(uUID)) continue;
                        this.application.stateService.setProfile(clientProfile);
                        break;
                    }
                }
                if (!((abstractScene = this.application.getCurrentScene()) instanceof ServerMenuScene) && !(abstractScene instanceof ServerInfoScene)) {
                    if (!(abstractScene instanceof SettingsScene | abstractScene instanceof OptionsScene)) break block9;
                }
                abstractScene.contextHelper.runInFxThread(abstractScene::reset);
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        return false;
    }
}

