/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.impl.FXExecutorService;
import pro.gravit.launcher.client.gui.utils.FXMLFactory;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractVisualComponent {
    protected final JavaFXApplication application;
    protected final ContextHelper contextHelper;
    protected final FXExecutorService fxExecutor;
    protected AbstractStage currentStage;
    protected Pane layout;
    private String sysFxmlPath;
    private Parent sysFxmlRoot;
    private CompletableFuture<Node> sysFxmlFuture;
    boolean isInit;
    protected boolean isResetOnShow = false;

    protected AbstractVisualComponent(String string, JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
        this.sysFxmlPath = string;
        this.contextHelper = new ContextHelper(this);
        this.fxExecutor = new FXExecutorService(this.contextHelper);
        if (javaFXApplication.guiModuleConfig.lazy) {
            this.sysFxmlFuture = javaFXApplication.fxmlFactory.getAsync(this.sysFxmlPath);
        }
    }

    public static void fade(Node node, double d, double d2, double d3, EventHandler<ActionEvent> eventHandler) {
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)100.0), node);
        if (eventHandler != null) {
            fadeTransition.setOnFinished(eventHandler);
        }
        fadeTransition.setDelay(Duration.millis((double)d));
        fadeTransition.setFromValue(d2);
        fadeTransition.setToValue(d3);
        fadeTransition.play();
    }

    public Pane getLayout() {
        return this.layout;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public abstract String getName();

    protected synchronized Parent getFxmlRoot() {
        try {
            if (this.sysFxmlRoot == null) {
                if (this.sysFxmlFuture == null) {
                    this.sysFxmlFuture = this.application.fxmlFactory.getAsync(this.sysFxmlPath);
                }
                this.sysFxmlRoot = (Parent)this.sysFxmlFuture.get();
            }
            return this.sysFxmlRoot;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new FXMLFactory.FXMLLoadException(throwable);
        }
    }

    public void init() throws Exception {
        if (this.layout == null) {
            this.layout = (Pane)this.getFxmlRoot();
        }
        this.doInit();
        this.isInit = true;
    }

    protected abstract void doInit() throws Exception;

    public abstract void reset();

    public abstract void disable();

    public abstract void enable();

    public void errorHandle(Throwable throwable) {
        String string = null;
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ExecutionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof RequestException) {
            string = throwable.getMessage();
        }
        string = string == null ? String.format("%s: %s", throwable.getClass().getName(), throwable.getMessage()) : this.application.getTranslation("runtime.request.".concat(string), string);
        LogHelper.error(throwable);
        this.application.messageManager.createNotification("Error", string);
    }
}

