/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.concurrent.atomic.AtomicReference;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;

public abstract class AbstractStage {
    public final Stage stage;
    protected AbstractVisualComponent scene;

    protected AbstractStage(Stage stage) {
        this.stage = stage;
    }

    public void hide() {
        this.stage.setIconified(true);
    }

    public void close() {
        this.stage.hide();
    }

    public void enableMouseDrag(Node node) {
        AtomicReference atomicReference = new AtomicReference();
        node.setOnMousePressed(mouseEvent -> atomicReference.set(new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY())));
        node.setOnMouseDragged(mouseEvent -> {
            if (atomicReference.get() == null) {
                return;
            }
            this.stage.setX(mouseEvent.getScreenX() - ((Point2D)atomicReference.get()).getX());
            this.stage.setY(mouseEvent.getScreenY() - ((Point2D)atomicReference.get()).getY());
        });
    }

    public AbstractVisualComponent getVisualComponent() {
        return this.scene;
    }

    public void setScene(AbstractVisualComponent abstractVisualComponent) throws Exception {
        if (abstractVisualComponent == null) {
            throw new NullPointerException("Try set null scene");
        }
        abstractVisualComponent.currentStage = this;
        if (!abstractVisualComponent.isInit()) {
            abstractVisualComponent.init();
        }
        if (abstractVisualComponent.isResetOnShow) {
            abstractVisualComponent.reset();
        }
        if (abstractVisualComponent instanceof AbstractScene) {
            this.stage.setScene(((AbstractScene)abstractVisualComponent).getScene());
        } else {
            Scene scene = new Scene((Parent)abstractVisualComponent.layout);
            scene.setFill((Paint)Color.TRANSPARENT);
            this.stage.setScene(scene);
        }
        this.stage.sizeToScene();
        this.scene = abstractVisualComponent;
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    public final boolean isNullScene() {
        return this.scene == null;
    }

    public void show() {
        this.stage.show();
    }
}

