/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.helper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.utils.RuntimeCryptedFile;
import pro.gravit.utils.enfs.EnFS;
import pro.gravit.utils.enfs.dir.FileEntry;
import pro.gravit.utils.enfs.dir.URLFile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class EnFSHelper {
    private static final Set<String> themesCached = new HashSet<String>(1);
    private static final String BASE_DIRECTORY = "tgui";

    public static boolean checkEnFSUrl() {
        try {
            URL uRL = new URL(new URL("enfs", null, -1, "aone").toString());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void initEnFS() throws IOException {
        if (JVMHelper.JVM_VERSION == 8) {
            LogHelper.info("Java pkgs: %s", System.getProperty("java.protocol.handler.pkgs"));
            System.setProperty("java.protocol.handler.pkgs", "pro.gravit.utils.enfs.protocol");
        }
        EnFS.main.newDirectory(Paths.get(BASE_DIRECTORY, new String[0]));
    }

    public static Path initEnFSDirectory(LauncherConfig launcherConfig, String string) throws IOException {
        Set set;
        String string3;
        Path path = Paths.get(BASE_DIRECTORY, string != null ? string : "common");
        if (string != null) {
            if (themesCached.contains(string)) {
                return path;
            }
            string3 = String.format("themes/%s/", string);
            EnFS.main.newDirectory(path);
            set = new HashSet();
            launcherConfig.runtime.forEach((string2, byArray) -> {
                if (string2.startsWith(string3)) {
                    set.add(string2.substring(string3.length()));
                }
            });
            themesCached.add(string);
        } else {
            string3 = "themes/common/";
            set = Collections.emptySet();
        }
        launcherConfig.runtime.forEach((string2, byArray) -> {
            String string3;
            if (string2.startsWith(string3)) {
                string3 = string2.substring(string3.length());
            } else {
                if (set.contains(string2)) {
                    return;
                }
                string3 = string2;
            }
            try {
                Path path2 = path.resolve(string3);
                EnFS.main.newDirectories(path2.getParent());
                FileEntry fileEntry = EnFSHelper.makeFile(launcherConfig, string2, byArray);
                EnFS.main.addFile(path2, fileEntry);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        });
        return path;
    }

    private static FileEntry makeFile(LauncherConfig launcherConfig, String string, byte[] byArray) throws IOException {
        Object object;
        if (launcherConfig.runtimeEncryptKey == null) {
            object = new URLFile(Launcher.getResourceURL(string));
        } else {
            String string2 = "runtime/" + SecurityHelper.toHex(byArray);
            object = new RuntimeCryptedFile(() -> {
                try {
                    return IOHelper.newInput(IOHelper.getResourceURL(string2));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }, SecurityHelper.fromHex(launcherConfig.runtimeEncryptKey));
        }
        return object;
    }

    public static URL getURL(String string) throws IOException {
        URL uRL;
        block8: {
            InputStream inputStream = EnFS.main.getInputStream(Paths.get(string, new String[0]));
            try {
                uRL = new URL("enfs", null, -1, string);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new FileNotFoundException(string);
                }
            }
            inputStream.close();
        }
        return uRL;
    }
}

