/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.api.DialogService;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.client.RuntimeSecurityService;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.UserSettings;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientGuiPhase;
import pro.gravit.launcher.client.gui.SkinManager;
import pro.gravit.launcher.client.gui.commands.RuntimeCommand;
import pro.gravit.launcher.client.gui.commands.VersionCommand;
import pro.gravit.launcher.client.gui.config.GuiModuleConfig;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.config.StdSettingsManager;
import pro.gravit.launcher.client.gui.helper.EnFSHelper;
import pro.gravit.launcher.client.gui.impl.GuiEventHandler;
import pro.gravit.launcher.client.gui.impl.GuiObjectsContainer;
import pro.gravit.launcher.client.gui.impl.MessageManager;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.service.JavaService;
import pro.gravit.launcher.client.gui.service.OfflineService;
import pro.gravit.launcher.client.gui.service.PingService;
import pro.gravit.launcher.client.gui.service.RuntimeDialogService;
import pro.gravit.launcher.client.gui.service.StateService;
import pro.gravit.launcher.client.gui.stage.PrimaryStage;
import pro.gravit.launcher.client.gui.utils.FXMLFactory;
import pro.gravit.launcher.client.gui.utils.TriggerManager;
import pro.gravit.launcher.debug.DebugMain;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.managers.SettingsManager;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaFXApplication
extends Application {
    private static final AtomicReference<JavaFXApplication> INSTANCE = new AtomicReference();
    private static final AtomicBoolean IS_NOGUI = new AtomicBoolean(false);
    private static Path runtimeDirectory = null;
    public final LauncherConfig config = Launcher.getConfig();
    public final ExecutorService workers = Executors.newWorkStealingPool(4);
    public RuntimeSettings runtimeSettings;
    public RequestService service;
    public GuiObjectsContainer gui;
    public StateService stateService;
    public GuiModuleConfig guiModuleConfig;
    public MessageManager messageManager;
    public RuntimeSecurityService securityService;
    public SkinManager skinManager;
    public FXMLFactory fxmlFactory;
    public JavaService javaService;
    public PingService pingService;
    public OfflineService offlineService;
    public TriggerManager triggerManager;
    private SettingsManager settingsManager;
    private PrimaryStage mainStage;
    private boolean debugMode;
    private ResourceBundle resources;
    private static Path enfsDirectory;
    private CommandCategory runtimeCategory;

    public JavaFXApplication() {
        INSTANCE.set(this);
    }

    public static JavaFXApplication getInstance() {
        return INSTANCE.get();
    }

    public AbstractScene getCurrentScene() {
        return (AbstractScene)this.mainStage.getVisualComponent();
    }

    public PrimaryStage getMainStage() {
        return this.mainStage;
    }

    public void init() throws Exception {
        this.guiModuleConfig = new GuiModuleConfig();
        this.settingsManager = new StdSettingsManager();
        UserSettings.providers.register("stdruntime", RuntimeSettings.class);
        this.settingsManager.loadConfig();
        NewLauncherSettings newLauncherSettings = this.settingsManager.getConfig();
        if (newLauncherSettings.userSettings.get("stdruntime") == null) {
            newLauncherSettings.userSettings.put("stdruntime", RuntimeSettings.getDefault(this.guiModuleConfig));
        }
        try {
            this.settingsManager.loadHDirStore();
        }
        catch (Exception exception) {
            LogHelper.error(exception);
        }
        this.runtimeSettings = (RuntimeSettings)newLauncherSettings.userSettings.get("stdruntime");
        this.runtimeSettings.apply();
        DirBridge.dirUpdates = this.runtimeSettings.updatesDir == null ? DirBridge.defaultUpdatesDir : this.runtimeSettings.updatesDir;
        this.service = Request.getRequestService();
        this.service.registerEventHandler(new GuiEventHandler(this));
        this.stateService = new StateService();
        this.messageManager = new MessageManager(this);
        this.securityService = new RuntimeSecurityService(this);
        this.skinManager = new SkinManager(this);
        this.triggerManager = new TriggerManager(this);
        this.javaService = new JavaService(this);
        this.offlineService = new OfflineService(this);
        this.pingService = new PingService();
        this.registerCommands();
    }

    public void start(Stage stage) throws Exception {
        block18: {
            block17: {
                try {
                    Class.forName("pro.gravit.launcher.debug.DebugMain", false, JavaFXApplication.class.getClassLoader());
                    if (DebugMain.IS_DEBUG.get()) {
                        runtimeDirectory = IOHelper.WORKING_DIR.resolve("runtime");
                        this.debugMode = true;
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ClassNotFoundException) break block17;
                    LogHelper.error(throwable);
                }
            }
            try {
                Class.forName("pro.gravit.utils.enfs.EnFS", false, JavaFXApplication.class.getClassLoader());
                if (runtimeDirectory == null) {
                    EnFSHelper.initEnFS();
                    enfsDirectory = EnFSHelper.initEnFSDirectory(this.config, this.runtimeSettings.theme);
                }
                if (!EnFSHelper.checkEnFSUrl()) {
                    JavaRuntimeModule.noEnFSAlert();
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof ClassNotFoundException) break block18;
                LogHelper.error(throwable);
            }
        }
        if (this.runtimeSettings.locale == null) {
            this.runtimeSettings.locale = RuntimeSettings.DEFAULT_LOCALE;
        }
        try {
            this.updateLocaleResources(this.runtimeSettings.locale.name);
        }
        catch (Throwable throwable) {
            JavaRuntimeModule.noLocaleAlert(this.runtimeSettings.locale.name);
            if (!(throwable instanceof FileNotFoundException)) {
                LogHelper.error(throwable);
            }
            Platform.exit();
        }
        RuntimeDialogService runtimeDialogService = new RuntimeDialogService(this.messageManager);
        DialogService.setDialogImpl(runtimeDialogService);
        DialogService.setNotificationImpl(runtimeDialogService);
        if (this.offlineService.isOfflineMode() && !this.offlineService.isAvailableOfflineMode() && !this.debugMode) {
            this.messageManager.showDialog(this.getTranslation("runtime.offline.dialog.header"), this.getTranslation("runtime.offline.dialog.text"), Platform::exit, Platform::exit, false);
            return;
        }
        try {
            this.mainStage = new PrimaryStage(stage, String.format("%s Launcher", this.config.projectName));
            this.gui = new GuiObjectsContainer(this);
            this.gui.init();
            if (!IS_NOGUI.get()) {
                this.mainStage.setScene(this.gui.loginScene);
                this.mainStage.show();
                if (this.offlineService.isOfflineMode()) {
                    this.messageManager.createNotification(this.getTranslation("runtime.offline.notification.header"), this.getTranslation("runtime.offline.notification.text"));
                }
            } else {
                Platform.setImplicitExit((boolean)false);
            }
            LauncherEngine.modulesManager.invokeEvent(new ClientGuiPhase(StdJavaRuntimeProvider.getInstance()));
            AuthRequest.registerProviders();
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            JavaRuntimeModule.errorHandleAlert(throwable);
            Platform.exit();
        }
    }

    public void updateLocaleResources(String string) throws IOException {
        try (InputStream inputStream = this.getResource(String.format("runtime_%s.properties", string));){
            this.resources = new PropertyResourceBundle(inputStream);
        }
        this.fxmlFactory = new FXMLFactory(this.resources, this.workers);
    }

    public void resetDirectory() throws IOException {
        if (enfsDirectory != null) {
            enfsDirectory = EnFSHelper.initEnFSDirectory(this.config, this.runtimeSettings.theme);
        }
    }

    private void registerCommands() {
        this.runtimeCategory = new BaseCommandCategory();
        this.runtimeCategory.registerCommand("version", new VersionCommand());
        if (ConsoleManager.isConsoleUnlock) {
            this.registerPrivateCommands();
        }
        ConsoleManager.handler.registerCategory(new CommandHandler.Category(this.runtimeCategory, "runtime"));
    }

    public void registerPrivateCommands() {
        if (this.runtimeCategory == null) {
            return;
        }
        this.runtimeCategory.registerCommand("runtime", new RuntimeCommand(this));
    }

    public void stop() {
        LogHelper.debug("JavaFX method stop invoked");
        LauncherEngine.modulesManager.invokeEvent(new ClientExitPhase(0));
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private InputStream getResource(String string) throws IOException {
        return IOHelper.newInput(JavaFXApplication.getResourceURL(string));
    }

    public static URL getResourceURL(String string) throws IOException {
        if (runtimeDirectory != null) {
            Path path = runtimeDirectory.resolve(string);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(String.format("File runtime/%s not found", string));
            }
            return path.toUri().toURL();
        }
        if (enfsDirectory != null) {
            return JavaFXApplication.getResourceEnFs(string);
        }
        return Launcher.getResourceURL(string);
    }

    private static URL getResourceEnFs(String string) throws IOException {
        return EnFSHelper.getURL(enfsDirectory.resolve(string).toString().replaceAll("\\\\", "/"));
    }

    public URL tryResource(String string) {
        try {
            return JavaFXApplication.getResourceURL(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public RuntimeSettings.ProfileSettings getProfileSettings() {
        return this.getProfileSettings(this.stateService.getProfile());
    }

    public RuntimeSettings.ProfileSettings getProfileSettings(ClientProfile clientProfile) {
        if (clientProfile == null) {
            throw new NullPointerException("ClientProfile not selected");
        }
        UUID uUID = clientProfile.getUUID();
        RuntimeSettings.ProfileSettings profileSettings = this.runtimeSettings.profileSettings.get(uUID);
        if (profileSettings == null) {
            profileSettings = RuntimeSettings.ProfileSettings.getDefault(this.javaService, clientProfile);
            this.runtimeSettings.profileSettings.put(uUID, profileSettings);
        }
        return profileSettings;
    }

    public static void setNoGUIMode(boolean bl) {
        IS_NOGUI.set(bl);
    }

    public void setMainScene(AbstractScene abstractScene) throws Exception {
        this.mainStage.setScene(abstractScene);
    }

    public Stage newStage() {
        return this.newStage(StageStyle.TRANSPARENT);
    }

    public Stage newStage(StageStyle stageStyle) {
        Stage stage = new Stage();
        stage.initStyle(stageStyle);
        stage.setResizable(false);
        return stage;
    }

    public final String getTranslation(String string) {
        return this.getTranslation(string, String.format("'%s'", string));
    }

    public final String getTranslation(String string, String string2) {
        try {
            return this.resources.getString(string);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    public boolean openURL(String string) {
        try {
            this.getHostServices().showDocument(string);
            return true;
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            return false;
        }
    }

    public void saveSettings() throws IOException {
        this.settingsManager.saveConfig();
        this.settingsManager.saveHDirStore();
        if (this.gui != null && this.gui.optionsScene != null && this.stateService != null && this.stateService.getProfiles() != null) {
            try {
                this.gui.optionsScene.saveAll();
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
    }
}

