/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launcher.request.secure.VerifySecureLevelKeyRequest;
import pro.gravit.launcher.utils.HWIDProvider;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class RuntimeSecurityService {
    private final JavaFXApplication application;
    private final Boolean[] waitObject = new Boolean[]{null};

    public RuntimeSecurityService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void startRequest() throws IOException {
        ((CompletableFuture)this.application.service.request(new GetSecureLevelInfoRequest()).thenAccept(getSecureLevelInfoRequestEvent -> {
            if (!getSecureLevelInfoRequestEvent.enabled || getSecureLevelInfoRequestEvent.verifySecureKey == null) {
                LogHelper.info("Advanced security level disabled");
                this.notifyWaitObject(false);
                return;
            }
            byte[] byArray = this.sign(getSecureLevelInfoRequestEvent.verifySecureKey);
            try {
                ((CompletableFuture)this.application.service.request(new VerifySecureLevelKeyRequest(JavaRuntimeModule.engine.publicKey.getEncoded(), byArray)).thenAccept(verifySecureLevelKeyRequestEvent -> {
                    Request.addExtendedToken("publicKey", verifySecureLevelKeyRequestEvent.extendedToken);
                    if (verifySecureLevelKeyRequestEvent.hardwareExtendedToken != null) {
                        Request.addExtendedToken("hardware", verifySecureLevelKeyRequestEvent.hardwareExtendedToken);
                    }
                    if (!verifySecureLevelKeyRequestEvent.needHardwareInfo) {
                        LogHelper.info("Advanced security level success completed");
                        this.notifyWaitObject(true);
                    } else {
                        this.doCollectHardwareInfo(!verifySecureLevelKeyRequestEvent.onlyStatisticInfo);
                    }
                })).exceptionally(throwable -> {
                    this.application.messageManager.createNotification("Hardware Checker", throwable.getCause().getMessage());
                    this.notifyWaitObject(false);
                    return null;
                });
            }
            catch (IOException iOException) {
                LogHelper.error("VerifySecureLevel failed: %s", iOException.getMessage());
                this.notifyWaitObject(false);
            }
        })).exceptionally(throwable -> {
            LogHelper.info("Advanced security level disabled(exception)");
            this.notifyWaitObject(false);
            return null;
        });
    }

    private void doCollectHardwareInfo(boolean bl) {
        CommonHelper.newThread("HardwareInfo Collector Thread", true, () -> {
            try {
                HWIDProvider hWIDProvider = new HWIDProvider();
                HardwareReportRequest.HardwareInfo hardwareInfo = hWIDProvider.getHardwareInfo(bl);
                HardwareReportRequest hardwareReportRequest = new HardwareReportRequest();
                hardwareReportRequest.hardware = hardwareInfo;
                ((CompletableFuture)this.application.service.request(hardwareReportRequest).thenAccept(hardwareReportRequestEvent -> {
                    Request.addExtendedToken("hardware", hardwareReportRequestEvent.extendedToken);
                    LogHelper.info("Advanced security level success completed");
                    this.notifyWaitObject(true);
                })).exceptionally(throwable -> {
                    this.application.messageManager.createNotification("Hardware Checker", throwable.getCause().getMessage());
                    return null;
                });
            }
            catch (Throwable throwable2) {
                LogHelper.error(throwable2);
                this.notifyWaitObject(false);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitObject(boolean bl) {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            this.waitObject[0] = bl;
            this.waitObject.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSecurityState() throws InterruptedException {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            if (this.waitObject[0] == null) {
                this.waitObject.wait(3000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.waitObject[0];
        }
    }

    public byte[] sign(byte[] byArray) {
        return SecurityHelper.sign(byArray, JavaRuntimeModule.engine.privateKey);
    }
}

