/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.Launcher;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class DirBridge {
    public static final String USE_CUSTOMDIR_PROPERTY = "launcher.usecustomdir";
    public static final String CUSTOMDIR_PROPERTY = "launcher.customdir";
    public static final String USE_OPTDIR_PROPERTY = "launcher.useoptdir";
    public static Path dir;
    public static Path dirStore;
    public static Path dirProjectStore;
    public static Path dirUpdates;
    public static Path defaultUpdatesDir;
    public static boolean useLegacyDir;

    public static void move(Path path) throws IOException {
        if (path == null) {
            LogHelper.debug("Invalid dir (null)");
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev(LogHelper.toString(new Throwable("Check stack of call DirBridge with null path...")));
            }
            return;
        }
        Path path2 = dirUpdates;
        dirUpdates = path;
        LogHelper.dev(path.toString());
        IOHelper.move(path2, dirUpdates);
    }

    public static Path getAppDataDir() throws IOException {
        boolean bl = Boolean.getBoolean(System.getProperty(USE_CUSTOMDIR_PROPERTY, "false"));
        if (bl) {
            return Paths.get(System.getProperty(CUSTOMDIR_PROPERTY), new String[0]);
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            boolean bl2 = Boolean.getBoolean(System.getProperty(USE_OPTDIR_PROPERTY, "false"));
            if (bl2) {
                Path path = Paths.get("/", new String[0]).resolve("opt");
                if (!IOHelper.isDir(path)) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                return path;
            }
            Path path = IOHelper.HOME_DIR.resolve(".minecraftlauncher");
            if (!IOHelper.isDir(path)) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            if (System.getenv().containsKey("appdata")) {
                return Paths.get(System.getenv().get("appdata"), new String[0]).toAbsolutePath();
            }
            if (System.getenv().containsKey("APPDATA")) {
                return Paths.get(System.getenv().get("APPDATA"), new String[0]).toAbsolutePath();
            }
            Path path = IOHelper.HOME_DIR.resolve("AppData").resolve("Roaming");
            if (!IOHelper.isDir(path)) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) {
            Path path = IOHelper.HOME_DIR.resolve("minecraft");
            if (!IOHelper.isDir(path)) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        return IOHelper.HOME_DIR;
    }

    public static Path getLauncherDir(String string) throws IOException {
        return DirBridge.getAppDataDir().resolve(string);
    }

    public static Path getStoreDir(String string) throws IOException {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            return DirBridge.getAppDataDir().resolve("store");
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return DirBridge.getAppDataDir().resolve("GravitLauncherStore");
        }
        return DirBridge.getAppDataDir().resolve("minecraftStore");
    }

    public static Path getProjectStoreDir(String string) throws IOException {
        return DirBridge.getStoreDir(string).resolve(string);
    }

    public static Path getGuardDir() {
        return dir.resolve("guard");
    }

    public static Path getGuardDir(JVMHelper.ARCH aRCH, JVMHelper.OS oS) {
        Path path = DirBridge.getGuardDir().resolve(Launcher.makeSpecialGuardDirName(aRCH, oS));
        try {
            IOHelper.createParentDirs(path);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return path;
    }

    public static Path getLegacyLauncherDir(String string) {
        return IOHelper.HOME_DIR.resolve(string);
    }

    public static void setUseLegacyDir(boolean bl) {
        useLegacyDir = bl;
    }

    static {
        String string = Launcher.getConfig().projectName;
        try {
            dir = DirBridge.getLauncherDir(string);
            if (!IOHelper.exists(dir)) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!IOHelper.exists(defaultUpdatesDir = dir.resolve("updates"))) {
                Files.createDirectories(defaultUpdatesDir, new FileAttribute[0]);
            }
            if (!IOHelper.exists(dirStore = DirBridge.getStoreDir(string))) {
                Files.createDirectories(dirStore, new FileAttribute[0]);
            }
            if (!IOHelper.exists(dirProjectStore = DirBridge.getProjectStoreDir(string))) {
                Files.createDirectories(dirProjectStore, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
    }
}

