/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderCreateEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderLaunchedEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderParamsWrittedEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderPreLaunchEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherProcess {
    public final List<String> pre = new LinkedList<String>();
    public final ClientParams params = new ClientParams();
    public final List<String> jvmArgs = new LinkedList<String>();
    public final List<String> jvmModules = new LinkedList<String>();
    public final List<String> jvmModulesPaths = new LinkedList<String>();
    public final List<String> systemClientArgs = new LinkedList<String>();
    public final List<String> systemClassPath = new LinkedList<String>();
    public final Map<String, String> systemEnv = new HashMap<String, String>();
    public final String mainClass;
    private final transient Boolean[] waitWriteParams = new Boolean[]{false};
    public Path executeFile;
    public Path workDir;
    public JavaHelper.JavaVersion javaVersion;
    public boolean useLegacyJavaClassPathProperty;
    public boolean isStarted;
    private transient Process process;

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, String string) {
        this.executeFile = path;
        this.workDir = path2;
        this.javaVersion = javaVersion;
        this.mainClass = string;
    }

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, ClientProfile clientProfile, PlayerProfile playerProfile, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this(path, path2, javaVersion, path.resolve("resourcepacks"), clientProfile, playerProfile, null, string, hashedDir, hashedDir2, hashedDir3);
    }

    public ClientLauncherProcess(Path path, Path path2, ClientProfile clientProfile, PlayerProfile playerProfile, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this(path, path2, JavaHelper.JavaVersion.getCurrentJavaVersion(), path.resolve("resourcepacks"), clientProfile, playerProfile, null, string, hashedDir, hashedDir2, hashedDir3);
    }

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, Path path3, ClientProfile clientProfile, PlayerProfile playerProfile, OptionalView optionalView, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this.javaVersion = javaVersion;
        this.workDir = path.toAbsolutePath();
        this.executeFile = IOHelper.resolveJavaBin(this.javaVersion.jvmDir);
        this.mainClass = ClientLauncherEntryPoint.class.getName();
        this.params.clientDir = this.workDir.toString();
        this.params.resourcePackDir = path3.toAbsolutePath().toString();
        this.params.assetDir = path2.toAbsolutePath().toString();
        Path path4 = clientProfile.hasFlag(ClientProfile.CompatibilityFlags.LEGACY_NATIVES_DIR) ? this.workDir.resolve("natives") : this.workDir.resolve("natives").resolve(JVMHelper.OS_TYPE.name).resolve(javaVersion.arch.name);
        if (!Files.isDirectory(path4, new LinkOption[0])) {
            throw new RuntimeException(String.format("Natives dir %s not exist! Your operating system or architecture not supported", path4.toAbsolutePath()));
        }
        this.params.nativesDir = path4.toString();
        this.params.profile = clientProfile;
        this.params.playerProfile = playerProfile;
        this.params.accessToken = string;
        this.params.assetHDir = hashedDir2;
        this.params.clientHDir = hashedDir;
        this.params.javaHDir = hashedDir3;
        if (optionalView != null) {
            this.params.actions = optionalView.getEnabledActions();
        }
        this.applyClientProfile();
    }

    public static String getPathSeparator() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return ";";
        }
        return ":";
    }

    private void applyClientProfile() {
        this.systemClassPath.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString());
        Collections.addAll(this.jvmArgs, this.params.profile.getJvmArgs());
        for (OptionalAction optionalAction : this.params.actions) {
            if (!(optionalAction instanceof OptionalActionJvmArgs)) continue;
            this.jvmArgs.addAll(((OptionalActionJvmArgs)optionalAction).args);
        }
        this.systemEnv.put("JAVA_HOME", this.javaVersion.jvmDir.toString());
        Collections.addAll(this.systemClassPath, this.params.profile.getAlternativeClassPath());
        if (this.params.ram > 0) {
            this.jvmArgs.add("-Xmx" + this.params.ram + 'M');
        }
        this.params.oauth = Request.getOAuth();
        if (this.params.oauth == null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        this.params.authId = Request.getAuthId();
        this.params.oauthExpiredTime = Request.getTokenExpiredTime();
        this.params.extendedTokens = Request.getExtendedTokens();
        this.jvmModules.addAll(this.params.profile.getModules());
        this.jvmModulesPaths.addAll(this.params.profile.getModulePath());
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderCreateEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) throws IOException, InterruptedException {
        if (this.isStarted) {
            throw new IllegalStateException("Process already started");
        }
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderPreLaunchEvent(this));
        LinkedList<String> linkedList = new LinkedList<String>(this.pre);
        linkedList.add(this.executeFile.toString());
        linkedList.addAll(this.jvmArgs);
        if (this.javaVersion.version >= 9) {
            this.applyJava9Params(linkedList);
        }
        linkedList.add(JVMHelper.jvmProperty("java.library.path", this.params.nativesDir));
        if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.AGENT) {
            linkedList.add("-javaagent:".concat(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString()));
        } else if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            this.systemClassPath.addAll(ClientLauncherEntryPoint.resolveClassPath(this.workDir, this.params.actions, this.params.profile).filter(path -> !this.params.profile.getModulePath().contains(this.workDir.relativize((Path)path).toString())).map(Path::toString).collect(Collectors.toList()));
        }
        if (Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            linkedList.add(JVMHelper.jvmProperty("launcher.dev", String.valueOf(LogHelper.isDevEnabled())));
            linkedList.add(JVMHelper.jvmProperty("launcher.debug", String.valueOf(LogHelper.isDebugEnabled())));
            linkedList.add(JVMHelper.jvmProperty("launcher.stacktrace", String.valueOf(LogHelper.isStacktraceEnabled())));
        }
        if (this.useLegacyJavaClassPathProperty) {
            linkedList.add("-Djava.class.path=".concat(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath)));
        } else {
            linkedList.add("-cp");
            linkedList.add(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath));
        }
        linkedList.add(this.mainClass);
        linkedList.addAll(this.systemClientArgs);
        Object object = this.waitWriteParams;
        synchronized (this.waitWriteParams) {
            if (!this.waitWriteParams[0].booleanValue()) {
                this.waitWriteParams.wait(1000L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug("Commandline: %s", Arrays.toString(linkedList.toArray()));
            }
            object = new ProcessBuilder(linkedList);
            EnvHelper.addEnv((ProcessBuilder)object);
            ((ProcessBuilder)object).environment().put("JAVA_HOME", this.javaVersion.jvmDir.toAbsolutePath().toString());
            ((ProcessBuilder)object).environment().putAll(this.systemEnv);
            ((ProcessBuilder)object).directory(this.workDir.toFile());
            ((ProcessBuilder)object).inheritIO();
            if (bl) {
                ((ProcessBuilder)object).redirectErrorStream(true);
                ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.PIPE);
            }
            this.process = ((ProcessBuilder)object).start();
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderLaunchedEvent(this));
            this.isStarted = true;
            return;
        }
    }

    private void applyJava9Params(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : this.jvmModules) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(string);
        }
        for (String string : this.jvmModulesPaths) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(string);
        }
        if (stringBuilder2.length() > 0) {
            list.add("--add-modules");
            list.add(stringBuilder2.toString());
        }
        if (stringBuilder.length() > 0) {
            list.add("--module-path");
            list.add(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteParams(SocketAddress socketAddress) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(socketAddress);
            Object object = this.waitWriteParams;
            synchronized (this.waitWriteParams) {
                this.waitWriteParams[0] = true;
                this.waitWriteParams.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                object = serverSocket.accept();
                try (HOutput hOutput = new HOutput(((Socket)object).getOutputStream());){
                    byte[] byArray = IOHelper.encode(Launcher.gsonManager.gson.toJson(this.params));
                    hOutput.writeByteArray(byArray, 0);
                    this.params.clientHDir.write(hOutput);
                    this.params.assetHDir.write(hOutput);
                    if (this.params.javaHDir == null || this.params.javaHDir == this.params.assetHDir) {
                        hOutput.writeBoolean(false);
                    } else {
                        hOutput.writeBoolean(true);
                        this.params.javaHDir.write(hOutput);
                    }
                }
            }
        }
        {
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderParamsWrittedEvent(this));
            return;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public static class ClientParams {
        public String assetDir;
        public String clientDir;
        public String resourcePackDir;
        public String nativesDir;
        public PlayerProfile playerProfile;
        public ClientProfile profile;
        public String accessToken;
        public boolean autoEnter;
        public boolean fullScreen;
        public int ram;
        public int width;
        public int height;
        public Set<OptionalAction> actions = new HashSet<OptionalAction>();
        public UUID session;
        public AuthRequestEvent.OAuthRequestEvent oauth;
        public String authId;
        public long oauthExpiredTime;
        public Map<String, String> extendedTokens;
        public boolean offlineMode;
        public transient HashedDir assetHDir;
        public transient HashedDir clientHDir;
        public transient HashedDir javaHDir;

        public void addClientArgs(Collection<String> collection) {
            if (this.profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
                this.addModernClientArgs(collection);
            } else {
                this.addClientLegacyArgs(collection);
            }
        }

        public void addClientLegacyArgs(Collection<String> collection) {
            collection.add(this.playerProfile.username);
            collection.add(this.accessToken);
            Collections.addAll(collection, "--version", this.profile.getVersion().toString());
            Collections.addAll(collection, "--gameDir", this.clientDir);
            Collections.addAll(collection, "--assetsDir", this.assetDir);
        }

        private void addModernClientArgs(Collection<String> collection) {
            ClientProfile.Version version = this.profile.getVersion();
            Collections.addAll(collection, "--username", this.playerProfile.username);
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_2) >= 0) {
                Collections.addAll(collection, "--uuid", Launcher.toHash(this.playerProfile.uuid));
                Collections.addAll(collection, "--accessToken", this.accessToken);
                if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0) {
                    Collections.addAll(collection, "--userType", "mojang");
                    Collections.addAll(collection, "--userProperties", "{}");
                    Collections.addAll(collection, "--assetIndex", this.profile.getAssetIndex());
                }
            } else {
                Collections.addAll(collection, "--session", this.accessToken);
            }
            Collections.addAll(collection, "--version", this.profile.getVersion().toString());
            Collections.addAll(collection, "--gameDir", this.clientDir);
            Collections.addAll(collection, "--assetsDir", this.assetDir);
            Collections.addAll(collection, "--resourcePackDir", this.resourcePackDir);
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_9_4) >= 0) {
                Collections.addAll(collection, "--versionType", "Launcher v" + Version.getVersion().getVersionString());
            }
            if (this.autoEnter) {
                Collections.addAll(collection, "--server", this.profile.getServerAddress());
                Collections.addAll(collection, "--port", Integer.toString(this.profile.getServerPort()));
            }
            for (OptionalAction optionalAction : this.actions) {
                if (!(optionalAction instanceof OptionalActionClientArgs)) continue;
                collection.addAll(((OptionalActionClientArgs)optionalAction).args);
            }
            if (this.fullScreen) {
                Collections.addAll(collection, "--fullscreen", Boolean.toString(true));
            }
            if (this.width > 0 && this.height > 0) {
                Collections.addAll(collection, "--width", Integer.toString(this.width));
                Collections.addAll(collection, "--height", Integer.toString(this.height));
            }
        }
    }
}

