/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class ClientClassLoader
extends URLClassLoader {
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    public String nativePath;
    private final List<String> packages = new ArrayList<String>();

    public ClientClassLoader(URL[] uRLArray) {
        super(uRLArray);
        this.packages.add("pro.gravit.launcher.");
        this.packages.add("pro.gravit.utils.");
    }

    public ClientClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string != null) {
            for (String string2 : this.packages) {
                if (!string.startsWith(string2)) continue;
                return SYSTEM_CLASS_LOADER.loadClass(string);
            }
        }
        return super.loadClass(string, bl);
    }

    @Override
    public String findLibrary(String string) {
        return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(string).concat(JVMHelper.NATIVE_EXTENSION);
    }

    public void addAllowedPackage(String string) {
        this.packages.add(string);
    }

    @Override
    public void addURL(URL uRL) {
        super.addURL(uRL);
    }
}

