/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherInjectionConstructor;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final List<byte[]> secureConfigCertificates;
    private static final List<Class<?>> modulesClasses;
    private static final MethodType VOID_TYPE;
    public final String projectName;
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    public final String secureCheckHash;
    public final String secureCheckSalt;
    public final String passwordEncryptKey;
    public final String runtimeEncryptKey;
    public final String address;
    public String secretKeyClient;
    public String unlockSecret;
    public LauncherEnvironment environment;
    public long buildNumber;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput hInput) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey(hInput.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey(hInput.readByteArray(2048));
        this.secureCheckHash = "yvk4m8spSeqXfYbf5Xopls+SZOsECP8SXLgsMszAXhc=";
        this.secureCheckSalt = "98c0ae606a550d383b07f8edce040588";
        this.passwordEncryptKey = "203aacd2b3782374f8676a48e59441d5";
        this.runtimeEncryptKey = null;
        this.projectName = "GreenWeltRP";
        this.clientPort = 32269;
        this.secretKeyClient = "8a608807ff0b48ac";
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        this.address = "wss://launcher.greenweltrp.ru/api";
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int n = hInput.readLength(0);
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = hInput.readString(255);
            VerifyHelper.putIfAbsent(hashMap, string, hInput.readByteArray(2048), String.format("Duplicate runtime resource: '%s'", string));
        }
        this.runtime = Collections.unmodifiableMap(hashMap);
        this.unlockSecret = "7268cfb2253ea0a8111d3156e02a70f9";
        this.buildNumber = 15L;
    }

    public LauncherConfig(String string, ECPublicKey eCPublicKey, RSAPublicKey rSAPublicKey, Map<String, byte[]> map, String string2) {
        this.address = string;
        this.ecdsaPublicKey = eCPublicKey;
        this.rsaPublicKey = rSAPublicKey;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(map));
        this.projectName = string2;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String string, Map<String, byte[]> map, String string2, LauncherEnvironment launcherEnvironment, LauncherTrustManager launcherTrustManager) {
        this.address = string;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(map));
        this.projectName = string2;
        this.clientPort = 32148;
        this.trustManager = launcherTrustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = launcherEnvironment;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public static void initModules(LauncherModulesManager launcherModulesManager) {
        for (Class<?> clazz : modulesClasses) {
            try {
                launcherModulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        modulesClasses.clear();
    }

    @Override
    public void write(HOutput hOutput) throws IOException {
        hOutput.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        hOutput.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> set = this.runtime.entrySet();
        hOutput.writeLength(set.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            hOutput.writeString(entry.getKey(), 255);
            hOutput.writeByteArray(entry.getValue(), 2048);
        }
    }

    static {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBTDCB86ADAgECAgEAMAoGCCqGSM49BAMCMDoxIjAgBgNVBAMMGUdyZWVuV2VsdFJQIEF1dG9nZW5lcmF0ZWQxFDASBgNVBAoMC0dyZWVuV2VsdFJQMB4XDTI2MDMwMTAwMDAwMFoXDTM2MDIyNzAwMDAwMFowDTELMAkGA1UEAwwCY2EwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAASKWkzsFXIgfgeUwQAt96AVrTNP0L+Nh8Ce/+oj+xg2QcEA6RKVx61AaFwJ7T3tjKqo/H8H3CksGdtAnLHAIbnqoxcwFTATBgNVHSUEDDAKBggrBgEFBQcDAzAKBggqhkjOPQQDAgNIADBFAiA5TXhEWacTLER0zlMZQE+sMDIskTzHVDnikT78wKRC5gIhAMbfuEqxOTeEd52H+1FpkG9bSUur/Y1B6EjCiVHp2UND"));
        secureConfigCertificates = arrayList;
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(JavaRuntimeModule.class);
        modulesClasses = arrayList2;
        VOID_TYPE = MethodType.methodType(Void.TYPE);
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }
}

