/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import pro.gravit.launcher.CertificatePinningTrustManager;
import pro.gravit.utils.helper.IOHelper;

public class AsyncDownloader {
    public static final Callback IGNORE = l -> {};
    private static boolean isCertificatePinning = false;
    private static volatile SSLSocketFactory sslSocketFactory;
    private static volatile SSLContext sslContext;
    public final Callback callback;
    public volatile boolean isClosed;

    public AsyncDownloader(Callback callback) {
        this.callback = callback;
    }

    public AsyncDownloader() {
        this.callback = IGNORE;
    }

    public static SSLSocketFactory makeSSLSocketFactory() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslSocketFactory != null) {
            return sslSocketFactory;
        }
        SSLContext sSLContext = AsyncDownloader.makeSSLContext();
        sslSocketFactory = sSLContext.getSocketFactory();
        return sslSocketFactory;
    }

    public static SSLContext makeSSLContext() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslContext != null) {
            return sslContext;
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, CertificatePinningTrustManager.getTrustManager().getTrustManagers(), new SecureRandom());
        return sSLContext;
    }

    public void downloadFile(URL uRL, Path path, long l) throws IOException {
        Object object;
        if (this.isClosed) {
            throw new IOException("Download interrupted");
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (isCertificatePinning) {
            object = (HttpsURLConnection)uRLConnection;
            try {
                ((HttpsURLConnection)object).setSSLSocketFactory(AsyncDownloader.makeSSLSocketFactory());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
        object = uRLConnection.getInputStream();
        try {
            this.transfer((InputStream)object, path, l);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public void downloadFile(URL uRL, Path path) throws IOException {
        Object object;
        URLConnection uRLConnection = uRL.openConnection();
        if (isCertificatePinning) {
            object = (HttpsURLConnection)uRLConnection;
            try {
                ((HttpsURLConnection)object).setSSLSocketFactory(AsyncDownloader.makeSSLSocketFactory());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
        object = uRLConnection.getInputStream();
        try {
            IOHelper.transfer((InputStream)object, path);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public void downloadListInOneThread(List<SizedFile> list, String string, Path path) throws URISyntaxException, IOException {
        URI uRI = new URI(string);
        String string2 = uRI.getScheme();
        String string3 = uRI.getHost();
        int n = uRI.getPort();
        if (n != -1) {
            string3 = string3 + ":" + n;
        }
        String string4 = uRI.getPath();
        for (SizedFile sizedFile : list) {
            URL uRL = new URI(string2, string3, string4 + sizedFile.urlPath, "", "").toURL();
            this.downloadFile(uRL, path.resolve(sizedFile.filePath), sizedFile.size);
        }
    }

    public void downloadListInOneThreadSimple(List<SizedFile> list, String string, Path path) throws IOException {
        for (SizedFile sizedFile : list) {
            this.downloadFile(new URL(string + sizedFile.urlPath), path.resolve(sizedFile.filePath), sizedFile.size);
        }
    }

    public List<List<SizedFile>> sortFiles(List<SizedFile> list, int n) {
        list.sort(Comparator.comparingLong(sizedFile -> -sizedFile.size));
        ArrayList<List<SizedFile>> arrayList = new ArrayList<List<SizedFile>>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new LinkedList());
        }
        long[] lArray = new long[n];
        Arrays.fill(lArray, 0L);
        for (SizedFile object : list) {
            long l = Long.MAX_VALUE;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (lArray[i] >= l) continue;
                l = lArray[i];
                n2 = i;
            }
            ((List)arrayList.get(n2)).add(object);
            int n3 = n2;
            lArray[n3] = lArray[n3] + object.size;
        }
        for (List list2 : arrayList) {
            Collections.shuffle(list2);
        }
        return arrayList;
    }

    public CompletableFuture[] runDownloadList(List<List<SizedFile>> list, String string, Path path, Executor executor) {
        int n = list.size();
        CompletableFuture[] completableFutureArray = new CompletableFuture[n];
        for (int i = 0; i < n; ++i) {
            List<SizedFile> list2 = list.get(i);
            completableFutureArray[i] = CompletableFuture.runAsync(() -> {
                try {
                    this.downloadListInOneThread(list2, string, path);
                }
                catch (IOException | URISyntaxException exception) {
                    throw new CompletionException(exception);
                }
            }, executor);
        }
        return completableFutureArray;
    }

    public CompletableFuture[] runDownloadListSimple(List<List<SizedFile>> list, String string, Path path, Executor executor) {
        int n = list.size();
        CompletableFuture[] completableFutureArray = new CompletableFuture[n];
        for (int i = 0; i < n; ++i) {
            List<SizedFile> list2 = list.get(i);
            completableFutureArray[i] = CompletableFuture.runAsync(() -> {
                try {
                    this.downloadListInOneThreadSimple(list2, string, path);
                }
                catch (IOException iOException) {
                    throw new CompletionException(iOException);
                }
            }, executor);
        }
        return completableFutureArray;
    }

    public void transfer(InputStream inputStream, Path path, long l) throws IOException {
        try (OutputStream outputStream = IOHelper.newOutput(path);){
            int n;
            byte[] byArray = IOHelper.newBuffer();
            for (long i = 0L; i < l; i += (long)n) {
                if (this.isClosed) {
                    throw new IOException("Download interrupted");
                }
                int n2 = (int)Math.min(l - i, (long)byArray.length);
                n = inputStream.read(byArray, 0, n2);
                if (n < 0) {
                    throw new EOFException(String.format("%d bytes remaining", l - i));
                }
                outputStream.write(byArray, 0, n);
                this.callback.update(n);
            }
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void update(long var1);
    }

    public static class SizedFile {
        public final String urlPath;
        public final String filePath;
        public final long size;

        public SizedFile(String string, long l) {
            this.urlPath = string;
            this.filePath = string;
            this.size = l;
        }

        public SizedFile(String string, String string2, long l) {
            this.urlPath = string;
            this.filePath = string2;
            this.size = l;
        }
    }
}

