/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import com.sun.jna.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.platform.unix.CLibrary;
import oshi.jna.platform.unix.FreeBsdLibc;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;

@ThreadSafe
final class FreeBsdNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdNetworkParams.class);
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    FreeBsdNetworkParams() {
    }

    @Override
    public String getDomainName() {
        try (CLibrary.Addrinfo addrinfo = new CLibrary.Addrinfo();){
            ByRef.CloseablePointerByReference closeablePointerByReference;
            block13: {
                addrinfo.ai_flags = 2;
                String string = this.getHostName();
                closeablePointerByReference = new ByRef.CloseablePointerByReference();
                try {
                    int n = LIBC.getaddrinfo(string, null, addrinfo, closeablePointerByReference);
                    if (n <= 0) break block13;
                    if (LOG.isErrorEnabled()) {
                        LOG.warn("Failed getaddrinfo(): {}", (Object)LIBC.gai_strerror(n));
                    }
                    String string2 = "";
                    closeablePointerByReference.close();
                    return string2;
                }
                catch (Throwable throwable) {
                    try {
                        closeablePointerByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            CLibrary.Addrinfo addrinfo2 = new CLibrary.Addrinfo(closeablePointerByReference.getValue());
            String string = addrinfo2.ai_canonname.trim();
            LIBC.freeaddrinfo(closeablePointerByReference.getValue());
            String string3 = string;
            closeablePointerByReference.close();
            return string3;
        }
    }

    @Override
    public String getHostName() {
        byte[] byArray = new byte[256];
        if (0 != LIBC.gethostname(byArray, byArray.length)) {
            return super.getHostName();
        }
        return Native.toString(byArray);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -4 get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -6 get default"));
    }
}

