/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Native;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.platform.mac.SystemB;
import oshi.jna.platform.unix.CLibrary;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class MacNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworkParams.class);
    private static final SystemB SYS = SystemB.INSTANCE;
    private static final String IPV6_ROUTE_HEADER = "Internet6:";
    private static final String DEFAULT_GATEWAY = "default";

    MacNetworkParams() {
    }

    @Override
    public String getDomainName() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            LOG.error("Unknown host exception when getting address of local host: {}", (Object)unknownHostException.getMessage());
            return "";
        }
        try (CLibrary.Addrinfo addrinfo = new CLibrary.Addrinfo();){
            ByRef.CloseablePointerByReference closeablePointerByReference;
            block15: {
                closeablePointerByReference = new ByRef.CloseablePointerByReference();
                try {
                    addrinfo.ai_flags = 2;
                    int n = SYS.getaddrinfo(string, null, addrinfo, closeablePointerByReference);
                    if (n <= 0) break block15;
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Failed getaddrinfo(): {}", (Object)SYS.gai_strerror(n));
                    }
                    String string2 = "";
                    closeablePointerByReference.close();
                    return string2;
                }
                catch (Throwable throwable) {
                    try {
                        closeablePointerByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            CLibrary.Addrinfo addrinfo2 = new CLibrary.Addrinfo(closeablePointerByReference.getValue());
            String string3 = addrinfo2.ai_canonname.trim();
            SYS.freeaddrinfo(closeablePointerByReference.getValue());
            String string4 = string3;
            closeablePointerByReference.close();
            return string4;
        }
    }

    @Override
    public String getHostName() {
        byte[] byArray = new byte[256];
        if (0 != SYS.gethostname(byArray, byArray.length)) {
            return super.getHostName();
        }
        return Native.toString(byArray);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return MacNetworkParams.searchGateway(ExecutingCommand.runNative("route -n get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        List<String> list = ExecutingCommand.runNative("netstat -nr");
        boolean bl = false;
        for (String string : list) {
            if (bl && string.startsWith(DEFAULT_GATEWAY)) {
                String[] stringArray = ParseUtil.whitespaces.split(string);
                if (stringArray.length <= 2 || !stringArray[2].contains("G")) continue;
                return stringArray[1].split("%")[0];
            }
            if (!string.startsWith(IPV6_ROUTE_HEADER)) continue;
            bl = true;
        }
        return "";
    }
}

