/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;
import oshi.jna.ByRef;
import oshi.jna.Struct;

@Immutable
final class WindowsDisplay
extends AbstractDisplay {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisplay.class);
    private static final SetupApi SU = SetupApi.INSTANCE;
    private static final Advapi32 ADV = Advapi32.INSTANCE;
    private static final Guid.GUID GUID_DEVINTERFACE_MONITOR = new Guid.GUID("E6F07B5F-EE97-4a90-B076-33F57BF4EAA7");

    WindowsDisplay(byte[] byArray) {
        super(byArray);
        LOG.debug("Initialized WindowsDisplay");
    }

    public static List<Display> getDisplays() {
        ArrayList<Display> arrayList = new ArrayList<Display>();
        WinNT.HANDLE hANDLE = SU.SetupDiGetClassDevs(GUID_DEVINTERFACE_MONITOR, null, null, 18);
        if (!hANDLE.equals(WinBase.INVALID_HANDLE_VALUE)) {
            try (Struct.CloseableSpDeviceInterfaceData closeableSpDeviceInterfaceData = new Struct.CloseableSpDeviceInterfaceData();
                 Struct.CloseableSpDevinfoData closeableSpDevinfoData = new Struct.CloseableSpDevinfoData();){
                closeableSpDeviceInterfaceData.cbSize = closeableSpDeviceInterfaceData.size();
                int n = 0;
                while (SU.SetupDiEnumDeviceInfo(hANDLE, n, closeableSpDevinfoData)) {
                    WinReg.HKEY hKEY = SU.SetupDiOpenDevRegKey(hANDLE, closeableSpDevinfoData, 1, 0, 1, 1);
                    byte[] byArray = new byte[1];
                    try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();
                         ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference();){
                        if (ADV.RegQueryValueEx(hKEY, "EDID", 0, (IntByReference)closeableIntByReference, byArray, (IntByReference)closeableIntByReference2) == 234 && ADV.RegQueryValueEx(hKEY, "EDID", 0, (IntByReference)closeableIntByReference, byArray = new byte[closeableIntByReference2.getValue()], (IntByReference)closeableIntByReference2) == 0) {
                            WindowsDisplay windowsDisplay = new WindowsDisplay(byArray);
                            arrayList.add(windowsDisplay);
                        }
                    }
                    Advapi32.INSTANCE.RegCloseKey(hKEY);
                    ++n;
                }
            }
            SU.SetupDiDestroyDeviceInfoList(hANDLE);
        }
        return arrayList;
    }
}

