/*
 * Decompiled with CFR 0.152.
 */
package okio;

public final class Utf8 {
    private Utf8() {
    }

    public static long size(String string) {
        return Utf8.size(string, 0, string.length());
    }

    public static long size(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n2 + " < " + n);
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n2 + " > " + string.length());
        }
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            char c;
            char c2 = string.charAt(n3);
            if (c2 < '\u0080') {
                ++l;
                ++n3;
                continue;
            }
            if (c2 < '\u0800') {
                l += 2L;
                ++n3;
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                l += 3L;
                ++n3;
                continue;
            }
            char c3 = c = n3 + 1 < n2 ? string.charAt(n3 + 1) : (char)'\u0000';
            if (c2 > '\udbff' || c < '\udc00' || c > '\udfff') {
                ++l;
                ++n3;
                continue;
            }
            l += 4L;
            n3 += 2;
        }
        return l;
    }
}

