/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long l, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Timeout deadlineNanoTime(long l) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }
    };
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    public Timeout timeout(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + l);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.timeoutNanos = timeUnit.toNanos(l);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            throw new IllegalStateException("No deadline");
        }
        return this.deadlineNanoTime;
    }

    public Timeout deadlineNanoTime(long l) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l;
        return this;
    }

    public final Timeout deadline(long l, TimeUnit timeUnit) {
        if (l <= 0L) {
            throw new IllegalArgumentException("duration <= 0: " + l);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException("deadline reached");
        }
    }

    public final void waitUntilNotified(Object object) throws InterruptedIOException {
        try {
            long l;
            long l2;
            boolean bl = this.hasDeadline();
            long l3 = this.timeoutNanos();
            if (!bl && l3 == 0L) {
                object.wait();
                return;
            }
            long l4 = System.nanoTime();
            if (bl && l3 != 0L) {
                l2 = this.deadlineNanoTime() - l4;
                l = Math.min(l3, l2);
            } else {
                l = bl ? this.deadlineNanoTime() - l4 : l3;
            }
            l2 = 0L;
            if (l > 0L) {
                long l5 = l / 1000000L;
                object.wait(l5, (int)(l - l5 * 1000000L));
                l2 = System.nanoTime() - l4;
            }
            if (l2 >= l) {
                throw new InterruptedIOException("timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
    }

    static long minTimeout(long l, long l2) {
        if (l == 0L) {
            return l2;
        }
        if (l2 == 0L) {
            return l;
        }
        if (l < l2) {
            return l;
        }
        return l2;
    }
}

