/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio.Util;

final class SegmentedByteString
extends ByteString {
    final transient byte[][] segments;
    final transient int[] directory;

    SegmentedByteString(Buffer buffer, int n) {
        super(null);
        Util.checkOffsetAndCount(buffer.size, 0L, n);
        int n2 = 0;
        int n3 = 0;
        Segment segment = buffer.head;
        while (n2 < n) {
            if (segment.limit == segment.pos) {
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            n2 += segment.limit - segment.pos;
            ++n3;
            segment = segment.next;
        }
        this.segments = new byte[n3][];
        this.directory = new int[n3 * 2];
        n2 = 0;
        n3 = 0;
        segment = buffer.head;
        while (n2 < n) {
            this.segments[n3] = segment.data;
            if ((n2 += segment.limit - segment.pos) > n) {
                n2 = n;
            }
            this.directory[n3] = n2;
            this.directory[n3 + this.segments.length] = segment.pos;
            segment.shared = true;
            ++n3;
            segment = segment.next;
        }
    }

    @Override
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    public String string(Charset charset) {
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    public ByteString hmacSha1(ByteString byteString) {
        return this.toByteString().hmacSha1(byteString);
    }

    @Override
    public ByteString hmacSha256(ByteString byteString) {
        return this.toByteString().hmacSha256(byteString);
    }

    @Override
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    public ByteString substring(int n) {
        return this.toByteString().substring(n);
    }

    @Override
    public ByteString substring(int n, int n2) {
        return this.toByteString().substring(n, n2);
    }

    @Override
    public byte getByte(int n) {
        Util.checkOffsetAndCount(this.directory[this.segments.length - 1], n, 1L);
        int n2 = this.segment(n);
        int n3 = n2 == 0 ? 0 : this.directory[n2 - 1];
        int n4 = this.directory[n2 + this.segments.length];
        return this.segments[n2][n - n3 + n4];
    }

    private int segment(int n) {
        int n2 = Arrays.binarySearch(this.directory, 0, this.segments.length, n + 1);
        return n2 >= 0 ? n2 : ~n2;
    }

    @Override
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.directory[this.segments.length - 1]];
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            System.arraycopy(this.segments[i], n3, byArray, n, n4 - n);
            n = n4;
        }
        return byArray;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            outputStream.write(this.segments[i], n3, n4 - n);
            n = n4;
        }
    }

    @Override
    void write(Buffer buffer) {
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            Segment segment = new Segment(this.segments[i], n3, n3 + n4 - n, true, false);
            if (buffer.head == null) {
                segment.next = segment.prev = segment;
                buffer.head = segment.prev;
            } else {
                buffer.head.prev.push(segment);
            }
            n = n4;
        }
        buffer.size += (long)n;
    }

    @Override
    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        if (n < 0 || n > this.size() - n3) {
            return false;
        }
        int n4 = this.segment(n);
        while (n3 > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = n4 == 0 ? 0 : this.directory[n4 - 1];
            int n9 = n - n8 + (n7 = this.directory[this.segments.length + n4]);
            if (!byteString.rangeEquals(n2, this.segments[n4], n9, n6 = Math.min(n3, n8 + (n5 = this.directory[n4] - n8) - n))) {
                return false;
            }
            n += n6;
            n2 += n6;
            n3 -= n6;
            ++n4;
        }
        return true;
    }

    @Override
    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        if (n < 0 || n > this.size() - n3 || n2 < 0 || n2 > byArray.length - n3) {
            return false;
        }
        int n4 = this.segment(n);
        while (n3 > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = n4 == 0 ? 0 : this.directory[n4 - 1];
            int n9 = n - n8 + (n7 = this.directory[this.segments.length + n4]);
            if (!Util.arrayRangeEquals(this.segments[n4], n9, byArray, n2, n6 = Math.min(n3, n8 + (n5 = this.directory[n4] - n8) - n))) {
                return false;
            }
            n += n6;
            n2 += n6;
            n3 -= n6;
            ++n4;
        }
        return true;
    }

    @Override
    public int indexOf(byte[] byArray, int n) {
        return this.toByteString().indexOf(byArray, n);
    }

    @Override
    public int lastIndexOf(byte[] byArray, int n) {
        return this.toByteString().lastIndexOf(byArray, n);
    }

    private ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    byte[] internalArray() {
        return this.toByteArray();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ByteString && ((ByteString)object).size() == this.size() && this.rangeEquals(0, (ByteString)object, 0, this.size());
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n != 0) {
            return n;
        }
        n = 1;
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i = 0; i < n3; ++i) {
            byte[] byArray = this.segments[i];
            int n4 = this.directory[n3 + i];
            int n5 = this.directory[i];
            int n6 = n5 - n2;
            int n7 = n4 + n6;
            for (int j = n4; j < n7; ++j) {
                n = 31 * n + byArray[j];
            }
            n2 = n5;
        }
        this.hashCode = n;
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }

    private Object writeReplace() {
        return this.toByteString();
    }
}

