/*
 * Decompiled with CFR 0.152.
 */
package okio;

import javax.annotation.Nullable;
import okio.SegmentPool;

final class Segment {
    static final int SIZE = 8192;
    static final int SHARE_MINIMUM = 1024;
    final byte[] data;
    int pos;
    int limit;
    boolean shared;
    boolean owner;
    Segment next;
    Segment prev;

    Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    Segment(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        this.data = byArray;
        this.pos = n;
        this.limit = n2;
        this.shared = bl;
        this.owner = bl2;
    }

    final Segment sharedCopy() {
        this.shared = true;
        return new Segment(this.data, this.pos, this.limit, true, false);
    }

    final Segment unsharedCopy() {
        return new Segment((byte[])this.data.clone(), this.pos, this.limit, false, true);
    }

    @Nullable
    public final Segment pop() {
        Segment segment = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return segment;
    }

    public final Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int n) {
        Segment segment;
        if (n <= 0 || n > this.limit - this.pos) {
            throw new IllegalArgumentException();
        }
        if (n >= 1024) {
            segment = this.sharedCopy();
        } else {
            segment = SegmentPool.take();
            System.arraycopy(this.data, this.pos, segment.data, 0, n);
        }
        segment.limit = segment.pos + n;
        this.pos += n;
        this.prev.push(segment);
        return segment;
    }

    public final void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (!this.prev.owner) {
            return;
        }
        int n = this.limit - this.pos;
        int n2 = 8192 - this.prev.limit + (this.prev.shared ? 0 : this.prev.pos);
        if (n > n2) {
            return;
        }
        this.writeTo(this.prev, n);
        this.pop();
        SegmentPool.recycle(this);
    }

    public final void writeTo(Segment segment, int n) {
        if (!segment.owner) {
            throw new IllegalArgumentException();
        }
        if (segment.limit + n > 8192) {
            if (segment.shared) {
                throw new IllegalArgumentException();
            }
            if (segment.limit + n - segment.pos > 8192) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(segment.data, segment.pos, segment.data, 0, segment.limit - segment.pos);
            segment.limit -= segment.pos;
            segment.pos = 0;
        }
        System.arraycopy(this.data, this.pos, segment.data, segment.limit, n);
        segment.limit += n;
        this.pos += n;
    }
}

