/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.PeekSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer = new Buffer();
    public final Source source;
    boolean closed;

    RealBufferedSource(Source source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer buffer, long l) throws IOException {
        long l2;
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (l2 = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1L;
        }
        l2 = Math.min(l, this.buffer.size);
        return this.buffer.read(buffer, l2);
    }

    @Override
    public boolean exhausted() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
    }

    @Override
    public void require(long l) throws IOException {
        if (!this.request(l)) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (this.buffer.size < l) {
            if (this.source.read(this.buffer, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long l) throws IOException {
        this.require(l);
        return this.buffer.readByteString(l);
    }

    @Override
    public int select(Options options) throws IOException {
        int n;
        block3: {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            do {
                if ((n = this.buffer.selectPrefix(options, true)) == -1) {
                    return -1;
                }
                if (n != -2) break block3;
            } while (this.source.read(this.buffer, 8192L) != -1L);
            return -1;
        }
        int n2 = options.byteStrings[n].size();
        this.buffer.skip(n2);
        return n;
    }

    @Override
    public byte[] readByteArray() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long l) throws IOException {
        this.require(l);
        return this.buffer.readByteArray(l);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        try {
            this.require(byArray.length);
        }
        catch (EOFException eOFException) {
            int n = 0;
            while (this.buffer.size > 0L) {
                int n2 = this.buffer.read(byArray, n, (int)this.buffer.size);
                if (n2 == -1) {
                    throw new AssertionError();
                }
                n += n2;
            }
            throw eOFException;
        }
        this.buffer.readFully(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l;
        Util.checkOffsetAndCount(byArray.length, n, n2);
        if (this.buffer.size == 0L && (l = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.buffer.size);
        return this.buffer.read(byArray, n, n3);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        long l;
        if (this.buffer.size == 0L && (l = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public void readFully(Buffer buffer, long l) throws IOException {
        try {
            this.require(l);
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(buffer, l);
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        long l = 0L;
        while (this.source.read(this.buffer, 8192L) != -1L) {
            long l2 = this.buffer.completeSegmentByteCount();
            if (l2 <= 0L) continue;
            l += l2;
            sink.write(this.buffer, l2);
        }
        if (this.buffer.size() > 0L) {
            l += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l;
    }

    @Override
    public String readUtf8() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l) throws IOException {
        this.require(l);
        return this.buffer.readUtf8(l);
    }

    @Override
    public String readString(Charset charset) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    public String readString(long l, Charset charset) throws IOException {
        this.require(l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return this.buffer.readString(l, charset);
    }

    @Override
    @Nullable
    public String readUtf8Line() throws IOException {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        return this.buffer.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("limit < 0: " + l);
        }
        long l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
        long l3 = this.indexOf((byte)10, 0L, l2);
        if (l3 != -1L) {
            return this.buffer.readUtf8Line(l3);
        }
        if (l2 < Long.MAX_VALUE && this.request(l2) && this.buffer.getByte(l2 - 1L) == 13 && this.request(l2 + 1L) && this.buffer.getByte(l2) == 10) {
            return this.buffer.readUtf8Line(l2);
        }
        Buffer buffer = new Buffer();
        this.buffer.copyTo(buffer, 0L, Math.min(32L, this.buffer.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.buffer.size(), l) + " content=" + buffer.readByteString().hex() + '\u2026');
    }

    @Override
    public int readUtf8CodePoint() throws IOException {
        this.require(1L);
        byte by = this.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public long readDecimalLong() throws IOException {
        this.require(1L);
        int n = 0;
        while (this.request(n + 1)) {
            byte by = this.buffer.getByte(n);
            if (!(by >= 48 && by <= 57 || n == 0 && by == 45)) {
                if (n != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9] or '-' character but was %#x", by));
            }
            ++n;
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() throws IOException {
        this.require(1L);
        int n = 0;
        while (this.request(n + 1)) {
            byte by = this.buffer.getByte(n);
            if (!(by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70)) {
                if (n != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9a-fA-F] character but was %#x", by));
            }
            ++n;
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (l > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                throw new EOFException();
            }
            long l2 = Math.min(l, this.buffer.size());
            this.buffer.skip(l2);
            l -= l2;
        }
    }

    @Override
    public long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l) throws IOException {
        return this.indexOf(by, l, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (l < 0L || l2 < l) {
            throw new IllegalArgumentException(String.format("fromIndex=%s toIndex=%s", l, l2));
        }
        while (l < l2) {
            long l3 = this.buffer.indexOf(by, l, l2);
            if (l3 != -1L) {
                return l3;
            }
            long l4 = this.buffer.size;
            if (l4 >= l2 || this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l = Math.max(l, l4);
        }
        return -1L;
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l2;
        while ((l2 = this.buffer.indexOf(byteString, l)) == -1L) {
            long l3 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l = Math.max(l, l3 - (long)byteString.size() + 1L);
        }
        return l2;
    }

    @Override
    public long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l2;
        while ((l2 = this.buffer.indexOfElement(byteString, l)) == -1L) {
            long l3 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l = Math.max(l, l3);
        }
        return l2;
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString) throws IOException {
        return this.rangeEquals(l, byteString, 0, byteString.size());
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (l < 0L || n < 0 || n2 < 0 || byteString.size() - n < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            long l2 = l + (long)i;
            if (!this.request(l2 + 1L)) {
                return false;
            }
            if (this.buffer.getByte(l2) == byteString.getByte(n + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                long l;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                if (RealBufferedSource.this.buffer.size == 0L && (l = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                long l;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                Util.checkOffsetAndCount(byArray.length, n, n2);
                if (RealBufferedSource.this.buffer.size == 0L && (l = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(byArray, n, n2);
            }

            @Override
            public int available() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

