/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

final class RealBufferedSink
implements BufferedSink {
    public final Buffer buffer = new Buffer();
    public final Sink sink;
    boolean closed;

    RealBufferedSink(Sink sink) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        this.sink = sink;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(Buffer buffer, long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(buffer, l);
        this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(ByteString byteString) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byteString);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeUtf8(String string) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeUtf8(String string, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string, n, n2);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeUtf8CodePoint(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8CodePoint(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeString(String string, Charset charset) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeString(string, charset);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeString(String string, int n, int n2, Charset charset) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeString(string, n, n2, charset);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray, n, n2);
        return this.emitCompleteSegments();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        int n = this.buffer.write(byteBuffer);
        this.emitCompleteSegments();
        return n;
    }

    @Override
    public long writeAll(Source source) throws IOException {
        long l;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l2 = 0L;
        while ((l = source.read(this.buffer, 8192L)) != -1L) {
            l2 += l;
            this.emitCompleteSegments();
        }
        return l2;
    }

    @Override
    public BufferedSink write(Source source, long l) throws IOException {
        while (l > 0L) {
            long l2 = source.read(this.buffer, l);
            if (l2 == -1L) {
                throw new EOFException();
            }
            l -= l2;
            this.emitCompleteSegments();
        }
        return this;
    }

    @Override
    public BufferedSink writeByte(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeByte(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeShort(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShort(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeShortLe(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShortLe(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeInt(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeInt(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeIntLe(int n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeIntLe(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeLong(long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLong(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeLongLe(long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLongLe(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeDecimalLong(long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeDecimalLong(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeHexadecimalUnsignedLong(long l) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeHexadecimalUnsignedLong(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink emitCompleteSegments() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l = this.buffer.completeSegmentByteCount();
        if (l > 0L) {
            this.sink.write(this.buffer, l);
        }
        return this;
    }

    @Override
    public BufferedSink emit() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l = this.buffer.size();
        if (l > 0L) {
            this.sink.write(this.buffer, l);
        }
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                if (RealBufferedSink.this.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSink.this.buffer.writeByte((byte)n);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (RealBufferedSink.this.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSink.this.buffer.write(byArray, n, n2);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void flush() throws IOException {
                if (!RealBufferedSink.this.closed) {
                    RealBufferedSink.this.flush();
                }
            }

            @Override
            public void close() throws IOException {
                RealBufferedSink.this.close();
            }

            public String toString() {
                return RealBufferedSink.this + ".outputStream()";
            }
        };
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size > 0L) {
            this.sink.write(this.buffer, this.buffer.size);
        }
        this.sink.flush();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        Throwable throwable;
        block7: {
            if (this.closed) {
                return;
            }
            throwable = null;
            try {
                if (this.buffer.size > 0L) {
                    this.sink.write(this.buffer, this.buffer.size);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable3) {
                if (throwable != null) break block7;
                throwable = throwable3;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "buffer(" + this.sink + ")";
    }
}

