/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.concurrent.TimeUnit;
import okio.Timeout;

final class PushableTimeout
extends Timeout {
    private Timeout pushed;
    private boolean originalHasDeadline;
    private long originalDeadlineNanoTime;
    private long originalTimeoutNanos;

    PushableTimeout() {
    }

    void push(Timeout timeout) {
        this.pushed = timeout;
        this.originalHasDeadline = timeout.hasDeadline();
        this.originalDeadlineNanoTime = this.originalHasDeadline ? timeout.deadlineNanoTime() : -1L;
        this.originalTimeoutNanos = timeout.timeoutNanos();
        timeout.timeout(PushableTimeout.minTimeout(this.originalTimeoutNanos, this.timeoutNanos()), TimeUnit.NANOSECONDS);
        if (this.originalHasDeadline && this.hasDeadline()) {
            timeout.deadlineNanoTime(Math.min(this.deadlineNanoTime(), this.originalDeadlineNanoTime));
        } else if (this.hasDeadline()) {
            timeout.deadlineNanoTime(this.deadlineNanoTime());
        }
    }

    void pop() {
        this.pushed.timeout(this.originalTimeoutNanos, TimeUnit.NANOSECONDS);
        if (this.originalHasDeadline) {
            this.pushed.deadlineNanoTime(this.originalDeadlineNanoTime);
        } else {
            this.pushed.clearDeadline();
        }
    }
}

