/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.PushableTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Pipe {
    final long maxBufferSize;
    final Buffer buffer = new Buffer();
    boolean sinkClosed;
    boolean sourceClosed;
    private final Sink sink = new PipeSink();
    private final Source source = new PipeSource();
    @Nullable
    private Sink foldedSink;

    public Pipe(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("maxBufferSize < 1: " + l);
        }
        this.maxBufferSize = l;
    }

    public final Source source() {
        return this.source;
    }

    public final Sink sink() {
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fold(Sink sink) throws IOException {
        while (true) {
            Buffer buffer;
            boolean bl = false;
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                if (this.foldedSink != null) {
                    throw new IllegalStateException("sink already folded");
                }
                if (this.buffer.exhausted()) {
                    this.sourceClosed = true;
                    this.foldedSink = sink;
                    return;
                }
                bl = this.sinkClosed;
                buffer = new Buffer();
                buffer.write(this.buffer, this.buffer.size);
                this.buffer.notifyAll();
            }
            boolean bl2 = false;
            try {
                sink.write(buffer, buffer.size);
                if (bl) {
                    sink.close();
                } else {
                    sink.flush();
                }
                bl2 = true;
                continue;
            }
            finally {
                if (bl2) continue;
                Buffer buffer3 = this.buffer;
                synchronized (buffer3) {
                    this.sourceClosed = true;
                    this.buffer.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    final class PipeSource
    implements Source {
        final Timeout timeout = new Timeout();

        PipeSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer buffer, long l) throws IOException {
            Buffer buffer2 = Pipe.this.buffer;
            synchronized (buffer2) {
                if (Pipe.this.sourceClosed) {
                    throw new IllegalStateException("closed");
                }
                while (Pipe.this.buffer.size() == 0L) {
                    if (Pipe.this.sinkClosed) {
                        return -1L;
                    }
                    this.timeout.waitUntilNotified(Pipe.this.buffer);
                }
                long l2 = Pipe.this.buffer.read(buffer, l);
                Pipe.this.buffer.notifyAll();
                return l2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                Pipe.this.sourceClosed = true;
                Pipe.this.buffer.notifyAll();
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }

    final class PipeSink
    implements Sink {
        final PushableTimeout timeout = new PushableTimeout();

        PipeSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Buffer buffer, long l) throws IOException {
            Sink sink = null;
            Buffer buffer2 = Pipe.this.buffer;
            synchronized (buffer2) {
                if (Pipe.this.sinkClosed) {
                    throw new IllegalStateException("closed");
                }
                while (l > 0L) {
                    if (Pipe.this.foldedSink != null) {
                        sink = Pipe.this.foldedSink;
                        break;
                    }
                    if (Pipe.this.sourceClosed) {
                        throw new IOException("source is closed");
                    }
                    long l2 = Pipe.this.maxBufferSize - Pipe.this.buffer.size();
                    if (l2 == 0L) {
                        this.timeout.waitUntilNotified(Pipe.this.buffer);
                        continue;
                    }
                    long l3 = Math.min(l2, l);
                    Pipe.this.buffer.write(buffer, l3);
                    l -= l3;
                    Pipe.this.buffer.notifyAll();
                }
            }
            if (sink != null) {
                this.timeout.push(sink.timeout());
                try {
                    sink.write(buffer, l);
                }
                finally {
                    this.timeout.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Sink sink = null;
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    throw new IllegalStateException("closed");
                }
                if (Pipe.this.foldedSink != null) {
                    sink = Pipe.this.foldedSink;
                } else if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                    throw new IOException("source is closed");
                }
            }
            if (sink != null) {
                this.timeout.push(sink.timeout());
                try {
                    sink.flush();
                }
                finally {
                    this.timeout.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Sink sink = null;
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    return;
                }
                if (Pipe.this.foldedSink != null) {
                    sink = Pipe.this.foldedSink;
                } else {
                    if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                        throw new IOException("source is closed");
                    }
                    Pipe.this.sinkClosed = true;
                    Pipe.this.buffer.notifyAll();
                }
            }
            if (sink != null) {
                this.timeout.push(sink.timeout());
                try {
                    sink.close();
                }
                finally {
                    this.timeout.pop();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }
}

