/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;

final class PeekSource
implements Source {
    private final BufferedSource upstream;
    private final Buffer buffer;
    private Segment expectedSegment;
    private int expectedPos;
    private boolean closed;
    private long pos;

    PeekSource(BufferedSource bufferedSource) {
        this.upstream = bufferedSource;
        this.buffer = bufferedSource.buffer();
        this.expectedSegment = this.buffer.head;
        this.expectedPos = this.expectedSegment != null ? this.expectedSegment.pos : -1;
    }

    @Override
    public long read(Buffer buffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.expectedSegment != null && (this.expectedSegment != this.buffer.head || this.expectedPos != this.buffer.head.pos)) {
            throw new IllegalStateException("Peek source is invalid because upstream source was used");
        }
        if (l == 0L) {
            return 0L;
        }
        if (!this.upstream.request(this.pos + 1L)) {
            return -1L;
        }
        if (this.expectedSegment == null && this.buffer.head != null) {
            this.expectedSegment = this.buffer.head;
            this.expectedPos = this.buffer.head.pos;
        }
        long l2 = Math.min(l, this.buffer.size - this.pos);
        this.buffer.copyTo(buffer, this.pos, l2);
        this.pos += l2;
        return l2;
    }

    @Override
    public Timeout timeout() {
        return this.upstream.timeout();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

