/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import okio.Buffer;
import okio.ByteString;

public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    final ByteString[] byteStrings;
    final int[] trie;

    private Options(ByteString[] byteStringArray, int[] nArray) {
        this.byteStrings = byteStringArray;
        this.trie = nArray;
    }

    public static Options of(ByteString ... byteStringArray) {
        int n;
        int n2;
        if (byteStringArray.length == 0) {
            return new Options(new ByteString[0], new int[]{0, -1});
        }
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(Arrays.asList(byteStringArray));
        Collections.sort(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            arrayList2.add(-1);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            int n3 = Collections.binarySearch(arrayList, byteStringArray[n2]);
            arrayList2.set(n3, n2);
        }
        if (((ByteString)arrayList.get(0)).size() == 0) {
            throw new IllegalArgumentException("the empty byte string is not a supported option");
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ByteString byteString;
            ByteString byteString2 = (ByteString)arrayList.get(n2);
            n = n2 + 1;
            while (n < arrayList.size() && (byteString = (ByteString)arrayList.get(n)).startsWith(byteString2)) {
                if (byteString.size() == byteString2.size()) {
                    throw new IllegalArgumentException("duplicate option: " + byteString);
                }
                if ((Integer)arrayList2.get(n) > (Integer)arrayList2.get(n2)) {
                    arrayList.remove(n);
                    arrayList2.remove(n);
                    continue;
                }
                ++n;
            }
        }
        Buffer buffer = new Buffer();
        Options.buildTrieRecursive(0L, buffer, 0, arrayList, 0, arrayList.size(), arrayList2);
        int[] nArray = new int[Options.intCount(buffer)];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = buffer.readInt();
        }
        if (!buffer.exhausted()) {
            throw new AssertionError();
        }
        return new Options((ByteString[])byteStringArray.clone(), nArray);
    }

    private static void buildTrieRecursive(long l, Buffer buffer, int n, List<ByteString> list, int n2, int n3, List<Integer> list2) {
        if (n2 >= n3) {
            throw new AssertionError();
        }
        for (int i = n2; i < n3; ++i) {
            if (list.get(i).size() < n) {
                throw new AssertionError();
            }
        }
        ByteString byteString = list.get(n2);
        ByteString byteString2 = list.get(n3 - 1);
        int n4 = -1;
        if (n == byteString.size()) {
            n4 = list2.get(n2);
            byteString = list.get(++n2);
        }
        if (byteString.getByte(n) != byteString2.getByte(n)) {
            int n5;
            int n6 = 1;
            for (int i = n2 + 1; i < n3; ++i) {
                if (list.get(i - 1).getByte(n) == list.get(i).getByte(n)) continue;
                ++n6;
            }
            long l2 = l + (long)Options.intCount(buffer) + 2L + (long)(n6 * 2);
            buffer.writeInt(n6);
            buffer.writeInt(n4);
            for (int i = n2; i < n3; ++i) {
                n5 = list.get(i).getByte(n);
                if (i != n2 && n5 == list.get(i - 1).getByte(n)) continue;
                buffer.writeInt(n5 & 0xFF);
            }
            Buffer buffer2 = new Buffer();
            n5 = n2;
            while (n5 < n3) {
                byte by = list.get(n5).getByte(n);
                int n7 = n3;
                for (int i = n5 + 1; i < n3; ++i) {
                    if (by == list.get(i).getByte(n)) continue;
                    n7 = i;
                    break;
                }
                if (n5 + 1 == n7 && n + 1 == list.get(n5).size()) {
                    buffer.writeInt(list2.get(n5));
                } else {
                    buffer.writeInt((int)(-1L * (l2 + (long)Options.intCount(buffer2))));
                    Options.buildTrieRecursive(l2, buffer2, n + 1, list, n5, n7, list2);
                }
                n5 = n7;
            }
            buffer.write(buffer2, buffer2.size());
        } else {
            int n8 = 0;
            int n9 = Math.min(byteString.size(), byteString2.size());
            for (int i = n; i < n9 && byteString.getByte(i) == byteString2.getByte(i); ++i) {
                ++n8;
            }
            long l3 = l + (long)Options.intCount(buffer) + 2L + (long)n8 + 1L;
            buffer.writeInt(-n8);
            buffer.writeInt(n4);
            for (int i = n; i < n + n8; ++i) {
                buffer.writeInt(byteString.getByte(i) & 0xFF);
            }
            if (n2 + 1 == n3) {
                if (n + n8 != list.get(n2).size()) {
                    throw new AssertionError();
                }
                buffer.writeInt(list2.get(n2));
            } else {
                Buffer buffer3 = new Buffer();
                buffer.writeInt((int)(-1L * (l3 + (long)Options.intCount(buffer3))));
                Options.buildTrieRecursive(l3, buffer3, n + n8, list, n2, n3, list2);
                buffer.write(buffer3, buffer3.size());
            }
        }
    }

    @Override
    public ByteString get(int n) {
        return this.byteStrings[n];
    }

    @Override
    public final int size() {
        return this.byteStrings.length;
    }

    private static int intCount(Buffer buffer) {
        return (int)(buffer.size() / 4L);
    }
}

