/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    public static HashingSource hmacSha1(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA1");
    }

    public static HashingSource hmacSha256(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA256");
    }

    private HashingSource(Source source, String string) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source source, ByteString byteString, String string) {
        super(source);
        try {
            this.mac = Mac.getInstance(string);
            this.mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public long read(Buffer buffer, long l) throws IOException {
        long l2 = super.read(buffer, l);
        if (l2 != -1L) {
            long l3;
            long l4 = buffer.size - l2;
            Segment segment = buffer.head;
            for (l3 = buffer.size; l3 > l4; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l3 < buffer.size) {
                int n = (int)((long)segment.pos + l4 - l3);
                if (this.messageDigest != null) {
                    this.messageDigest.update(segment.data, n, segment.limit - n);
                } else {
                    this.mac.update(segment.data, n, segment.limit - n);
                }
                l4 = l3 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return l2;
    }

    public final ByteString hash() {
        byte[] byArray = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(byArray);
    }
}

