/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Base64;
import okio.Buffer;
import okio.Util;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        return new ByteString((byte[])byArray.clone());
    }

    public static ByteString of(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        Util.checkOffsetAndCount(byArray.length, n, n2);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new ByteString(byArray2);
    }

    public static ByteString of(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("data == null");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString encodeUtf8(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s == null");
        }
        ByteString byteString = new ByteString(string.getBytes(Util.UTF_8));
        byteString.utf8 = string;
        return byteString;
    }

    public static ByteString encodeString(String string, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new ByteString(string.getBytes(charset));
    }

    public String utf8() {
        String string = this.utf8;
        return string != null ? string : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String string(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new String(this.data, charset);
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    private ByteString digest(String string) {
        try {
            return ByteString.of(MessageDigest.getInstance(string).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    private ByteString hmac(String string, ByteString byteString) {
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            return ByteString.of(mac.doFinal(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    @Nullable
    public static ByteString decodeBase64(String string) {
        if (string == null) {
            throw new IllegalArgumentException("base64 == null");
        }
        byte[] byArray = Base64.decode(string);
        return byArray != null ? new ByteString(byArray) : null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n = 0;
        for (byte by : this.data) {
            cArray[n++] = HEX_DIGITS[by >> 4 & 0xF];
            cArray[n++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String string) {
        if (string == null) {
            throw new IllegalArgumentException("hex == null");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = ByteString.decodeHexDigit(string.charAt(i * 2)) << 4;
            int n2 = ByteString.decodeHexDigit(string.charAt(i * 2 + 1));
            byArray[i] = (byte)(n + n2);
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c);
    }

    public static ByteString read(InputStream inputStream, int n) throws IOException {
        int n2;
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("byteCount < 0: " + n);
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 != -1) continue;
            throw new EOFException();
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            if (by < 65 || by > 90) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i++] = (byte)(by - -32);
            while (i < byArray.length) {
                by = byArray[i];
                if (by >= 65 && by <= 90) {
                    byArray[i] = (byte)(by - -32);
                }
                ++i;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            if (by < 97 || by > 122) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i++] = (byte)(by - 32);
            while (i < byArray.length) {
                by = byArray[i];
                if (by >= 97 && by <= 122) {
                    byArray[i] = (byte)(by - 32);
                }
                ++i;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString substring(int n) {
        return this.substring(n, this.data.length);
    }

    public ByteString substring(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("beginIndex < 0");
        }
        if (n2 > this.data.length) {
            throw new IllegalArgumentException("endIndex > length(" + this.data.length + ")");
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException("endIndex < beginIndex");
        }
        if (n == 0 && n2 == this.data.length) {
            return this;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.data, n, byArray, 0, n3);
        return new ByteString(byArray);
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        outputStream.write(this.data);
    }

    void write(Buffer buffer) {
        buffer.write(this.data, 0, this.data.length);
    }

    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        return byteString.rangeEquals(n2, this.data, n, n3);
    }

    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        return n >= 0 && n <= this.data.length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && Util.arrayRangeEquals(this.data, n, byArray, n2, n3);
    }

    public final boolean startsWith(ByteString byteString) {
        return this.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(byte[] byArray) {
        return this.rangeEquals(0, byArray, 0, byArray.length);
    }

    public final boolean endsWith(ByteString byteString) {
        return this.rangeEquals(this.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(byte[] byArray) {
        return this.rangeEquals(this.size() - byArray.length, byArray, 0, byArray.length);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n) {
        return this.indexOf(byteString.internalArray(), n);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n) {
        int n2 = this.data.length - byArray.length;
        for (int i = n = Math.max(n, 0); i <= n2; ++i) {
            if (!Util.arrayRangeEquals(this.data, i, byArray, 0, byArray.length)) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString byteString) {
        return this.lastIndexOf(byteString.internalArray(), this.size());
    }

    public final int lastIndexOf(ByteString byteString, int n) {
        return this.lastIndexOf(byteString.internalArray(), n);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n) {
        for (int i = n = Math.min(n, this.data.length - byArray.length); i >= 0; --i) {
            if (!Util.arrayRangeEquals(this.data, i, byArray, 0, byArray.length)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ByteString && ((ByteString)object).size() == this.data.length && ((ByteString)object).rangeEquals(0, this.data, 0, this.data.length);
    }

    public int hashCode() {
        int n = this.hashCode;
        return n != 0 ? n : (this.hashCode = Arrays.hashCode(this.data));
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n = this.size();
        int n2 = byteString.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.getByte(i) & 0xFF;
            if (n5 == (n4 = byteString.getByte(i) & 0xFF)) continue;
            return n5 < n4 ? -1 : 1;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        String string = this.utf8();
        int n = ByteString.codePointIndexToCharIndex(string, 64);
        if (n == -1) {
            return this.data.length <= 64 ? "[hex=" + this.hex() + "]" : "[size=" + this.data.length + " hex=" + this.substring(0, 64).hex() + "\u2026]";
        }
        String string2 = string.substring(0, n).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        return n < string.length() ? "[size=" + this.data.length + " text=" + string2 + "\u2026]" : "[text=" + string2 + "]";
    }

    static int codePointIndexToCharIndex(String string, int n) {
        int n2;
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; i += Character.charCount(n2)) {
            if (n3 == n) {
                return i;
            }
            n2 = string.codePointAt(i);
            if (Character.isISOControl(n2) && n2 != 10 && n2 != 13 || n2 == 65533) {
                return -1;
            }
            ++n3;
        }
        return string.length();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        ByteString byteString = ByteString.read(objectInputStream, n);
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, byteString.data);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }
}

