/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.PeekSource;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Segment head;
    long size;

    public final long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public Buffer getBuffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n) {
                Buffer.this.writeByte((byte)n);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                Buffer.this.write(byArray, n, n2);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".outputStream()";
            }
        };
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l) throws EOFException {
        if (this.size < l) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long l) {
        return this.size >= l;
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                if (Buffer.this.size > 0L) {
                    return Buffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                return Buffer.this.read(byArray, n, n2);
            }

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".inputStream()";
            }
        };
    }

    public final Buffer copyTo(OutputStream outputStream) throws IOException {
        return this.copyTo(outputStream, 0L, this.size);
    }

    public final Buffer copyTo(OutputStream outputStream, long l, long l2) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, l, l2);
        if (l2 == 0L) {
            return this;
        }
        Segment segment = this.head;
        while (l >= (long)(segment.limit - segment.pos)) {
            l -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l2 > 0L) {
            int n = (int)((long)segment.pos + l);
            int n2 = (int)Math.min((long)(segment.limit - n), l2);
            outputStream.write(segment.data, n, n2);
            l2 -= (long)n2;
            l = 0L;
            segment = segment.next;
        }
        return this;
    }

    public final Buffer copyTo(Buffer buffer, long l, long l2) {
        if (buffer == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, l, l2);
        if (l2 == 0L) {
            return this;
        }
        buffer.size += l2;
        Segment segment = this.head;
        while (l >= (long)(segment.limit - segment.pos)) {
            l -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l2 > 0L) {
            Segment segment2 = segment.sharedCopy();
            segment2.pos = (int)((long)segment2.pos + l);
            segment2.limit = Math.min(segment2.pos + (int)l2, segment2.limit);
            if (buffer.head == null) {
                segment2.next = segment2.prev = segment2;
                buffer.head = segment2.prev;
            } else {
                buffer.head.prev.push(segment2);
            }
            l2 -= (long)(segment2.limit - segment2.pos);
            l = 0L;
            segment = segment.next;
        }
        return this;
    }

    public final Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public final Buffer writeTo(OutputStream outputStream, long l) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, 0L, l);
        Segment segment = this.head;
        while (l > 0L) {
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            outputStream.write(segment.data, segment.pos, n);
            segment.pos += n;
            this.size -= (long)n;
            l -= (long)n;
            if (segment.pos != segment.limit) continue;
            Segment segment2 = segment;
            this.head = segment = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return this;
    }

    public final Buffer readFrom(InputStream inputStream) throws IOException {
        this.readFrom(inputStream, Long.MAX_VALUE, true);
        return this;
    }

    public final Buffer readFrom(InputStream inputStream, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        this.readFrom(inputStream, l, false);
        return this;
    }

    private void readFrom(InputStream inputStream, long l, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        while (l > 0L || bl) {
            Segment segment = this.writableSegment(1);
            int n = (int)Math.min(l, (long)(8192 - segment.limit));
            int n2 = inputStream.read(segment.data, segment.limit, n);
            if (n2 == -1) {
                if (segment.pos == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                if (bl) {
                    return;
                }
                throw new EOFException();
            }
            segment.limit += n2;
            this.size += (long)n2;
            l -= (long)n2;
        }
    }

    public final long completeSegmentByteCount() {
        long l = this.size;
        if (l == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        if (segment.limit < 8192 && segment.owner) {
            l -= (long)(segment.limit - segment.pos);
        }
        return l;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int n = segment.pos;
        int n2 = segment.limit;
        byte[] byArray = segment.data;
        byte by = byArray[n++];
        --this.size;
        if (n == n2) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n;
        }
        return by;
    }

    public final byte getByte(long l) {
        Util.checkOffsetAndCount(this.size, l, 1L);
        if (this.size - l > l) {
            Segment segment = this.head;
            while (true) {
                int n;
                if (l < (long)(n = segment.limit - segment.pos)) {
                    return segment.data[segment.pos + (int)l];
                }
                l -= (long)n;
                segment = segment.next;
            }
        }
        l -= this.size;
        Segment segment = this.head.prev;
        while ((l += (long)(segment.limit - segment.pos)) < 0L) {
            segment = segment.prev;
        }
        return segment.data[segment.pos + (int)l];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 2) {
            int n3 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)n3;
        }
        byte[] byArray = segment.data;
        int n4 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 2L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return (short)n4;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = segment.data;
        int n3 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 4L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return n3;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] byArray = segment.data;
        long l = ((long)byArray[n2++] & 0xFFL) << 56 | ((long)byArray[n2++] & 0xFFL) << 48 | ((long)byArray[n2++] & 0xFFL) << 40 | ((long)byArray[n2++] & 0xFFL) << 32 | ((long)byArray[n2++] & 0xFFL) << 24 | ((long)byArray[n2++] & 0xFFL) << 16 | ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2++] & 0xFFL;
        this.size -= 8L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return l;
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public long readDecimalLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l = 0L;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = -922337203685477580L;
        long l3 = -7L;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                byte by = byArray[n2];
                if (by >= 48 && by <= 57) {
                    int n4 = 48 - by;
                    if (l < l2 || l == l2 && (long)n4 < l3) {
                        Buffer buffer = new Buffer().writeDecimalLong(l).writeByte(by);
                        if (!bl) {
                            buffer.readByte();
                        }
                        throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                    }
                    l *= 10L;
                    l += (long)n4;
                } else if (by == 45 && n == 0) {
                    bl = true;
                    --l3;
                } else {
                    if (n == 0) {
                        throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(by));
                    }
                    bl2 = true;
                    break;
                }
                ++n2;
                ++n;
            }
            if (n2 == n3) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl2 && this.head != null);
        this.size -= (long)n;
        return bl ? l : -l;
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l = 0L;
        int n = 0;
        boolean bl = false;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                int n4;
                byte by = byArray[n2];
                if (by >= 48 && by <= 57) {
                    n4 = by - 48;
                } else if (by >= 97 && by <= 102) {
                    n4 = by - 97 + 10;
                } else if (by >= 65 && by <= 70) {
                    n4 = by - 65 + 10;
                } else {
                    if (n == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(by));
                    }
                    bl = true;
                    break;
                }
                if ((l & 0xF000000000000000L) != 0L) {
                    Buffer buffer = new Buffer().writeHexadecimalUnsignedLong(l).writeByte(by);
                    throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                }
                l <<= 4;
                l |= (long)n4;
                ++n2;
                ++n;
            }
            if (n2 == n3) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl && this.head != null);
        this.size -= (long)n;
        return l;
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long l) throws EOFException {
        return new ByteString(this.readByteArray(l));
    }

    @Override
    public int select(Options options) {
        int n = this.selectPrefix(options, false);
        if (n == -1) {
            return -1;
        }
        int n2 = options.byteStrings[n].size();
        try {
            this.skip(n2);
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
        return n;
    }

    int selectPrefix(Options options, boolean bl) {
        Segment segment = this.head;
        if (segment == null) {
            if (bl) {
                return -2;
            }
            return options.indexOf(ByteString.EMPTY);
        }
        Segment segment2 = segment;
        byte[] byArray = segment.data;
        int n = segment.pos;
        int n2 = segment.limit;
        int[] nArray = options.trie;
        int n3 = 0;
        int n4 = -1;
        block0: while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = nArray[n3++];
            if ((n9 = nArray[n3++]) != -1) {
                n4 = n9;
            }
            if (segment2 == null) break;
            if (n10 < 0) {
                boolean bl2;
                n8 = -1 * n10;
                n7 = n3 + n8;
                do {
                    if ((n6 = byArray[n++] & 0xFF) != nArray[n3++]) {
                        return n4;
                    }
                    boolean bl3 = bl2 = n3 == n7;
                    if (n != n2) continue;
                    segment2 = segment2.next;
                    n = segment2.pos;
                    byArray = segment2.data;
                    n2 = segment2.limit;
                    if (segment2 != segment) continue;
                    if (!bl2) break block0;
                    segment2 = null;
                } while (!bl2);
                n5 = nArray[n3];
            } else {
                n8 = n10;
                n7 = byArray[n++] & 0xFF;
                n6 = n3 + n8;
                while (true) {
                    if (n3 == n6) {
                        return n4;
                    }
                    if (n7 == nArray[n3]) break;
                    ++n3;
                }
                n5 = nArray[n3 + n8];
                if (n == n2) {
                    segment2 = segment2.next;
                    n = segment2.pos;
                    byArray = segment2.data;
                    n2 = segment2.limit;
                    if (segment2 == segment) {
                        segment2 = null;
                    }
                }
            }
            if (n5 >= 0) {
                return n5;
            }
            n3 = -n5;
        }
        if (bl) {
            return -2;
        }
        return n4;
    }

    @Override
    public void readFully(Buffer buffer, long l) throws EOFException {
        if (this.size < l) {
            buffer.write(this, this.size);
            throw new EOFException();
        }
        buffer.write(this, l);
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l = this.size;
        if (l > 0L) {
            sink.write(this, l);
        }
        return l;
    }

    @Override
    public String readUtf8() {
        try {
            return this.readString(this.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long l) throws EOFException {
        return this.readString(l, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) {
        try {
            return this.readString(this.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readString(long l, Charset charset) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        if (l == 0L) {
            return "";
        }
        Segment segment = this.head;
        if ((long)segment.pos + l > (long)segment.limit) {
            return new String(this.readByteArray(l), charset);
        }
        String string = new String(segment.data, segment.pos, (int)l, charset);
        segment.pos = (int)((long)segment.pos + l);
        this.size -= l;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return string;
    }

    @Override
    @Nullable
    public String readUtf8Line() throws EOFException {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() throws EOFException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l) throws EOFException {
        if (l < 0L) {
            throw new IllegalArgumentException("limit < 0: " + l);
        }
        long l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
        long l3 = this.indexOf((byte)10, 0L, l2);
        if (l3 != -1L) {
            return this.readUtf8Line(l3);
        }
        if (l2 < this.size() && this.getByte(l2 - 1L) == 13 && this.getByte(l2) == 10) {
            return this.readUtf8Line(l2);
        }
        Buffer buffer = new Buffer();
        this.copyTo(buffer, 0L, Math.min(32L, this.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.size(), l) + " content=" + buffer.readByteString().hex() + '\u2026');
    }

    String readUtf8Line(long l) throws EOFException {
        if (l > 0L && this.getByte(l - 1L) == 13) {
            String string = this.readUtf8(l - 1L);
            this.skip(2L);
            return string;
        }
        String string = this.readUtf8(l);
        this.skip(1L);
        return string;
    }

    @Override
    public int readUtf8CodePoint() throws EOFException {
        int n;
        int n2;
        int n3;
        if (this.size == 0L) {
            throw new EOFException();
        }
        byte by = this.getByte(0L);
        if ((by & 0x80) == 0) {
            n3 = by & 0x7F;
            n2 = 1;
            n = 0;
        } else if ((by & 0xE0) == 192) {
            n3 = by & 0x1F;
            n2 = 2;
            n = 128;
        } else if ((by & 0xF0) == 224) {
            n3 = by & 0xF;
            n2 = 3;
            n = 2048;
        } else if ((by & 0xF8) == 240) {
            n3 = by & 7;
            n2 = 4;
            n = 65536;
        } else {
            this.skip(1L);
            return 65533;
        }
        if (this.size < (long)n2) {
            throw new EOFException("size < " + n2 + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(by) + ")");
        }
        for (int i = 1; i < n2; ++i) {
            byte by2 = this.getByte(i);
            if ((by2 & 0xC0) == 128) {
                n3 <<= 6;
                n3 |= by2 & 0x3F;
                continue;
            }
            this.skip(i);
            return 65533;
        }
        this.skip(n2);
        if (n3 > 0x10FFFF) {
            return 65533;
        }
        if (n3 >= 55296 && n3 <= 57343) {
            return 65533;
        }
        if (n3 < n) {
            return 65533;
        }
        return n3;
    }

    @Override
    public byte[] readByteArray() {
        try {
            return this.readByteArray(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long l) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        byte[] byArray = new byte[(int)l];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws EOFException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        Util.checkOffsetAndCount(byArray.length, n, n2);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n3 = Math.min(n2, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, byArray, n, n3);
        segment.pos += n3;
        this.size -= (long)n3;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n3;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byteBuffer.put(segment.data, segment.pos, n);
        segment.pos += n;
        this.size -= (long)n;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n;
    }

    public final void clear() {
        try {
            this.skip(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public void skip(long l) throws EOFException {
        while (l > 0L) {
            if (this.head == null) {
                throw new EOFException();
            }
            int n = (int)Math.min(l, (long)(this.head.limit - this.head.pos));
            this.size -= (long)n;
            l -= (long)n;
            this.head.pos += n;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        byteString.write(this);
        return this;
    }

    @Override
    public Buffer writeUtf8(String string) {
        return this.writeUtf8(string, 0, string.length());
    }

    @Override
    public Buffer writeUtf8(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n2 + " < " + n);
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n2 + " > " + string.length());
        }
        int n3 = n;
        while (n3 < n2) {
            char c;
            char c2 = string.charAt(n3);
            if (c2 < '\u0080') {
                Segment segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                int n4 = segment.limit - n3;
                int n5 = Math.min(n2, 8192 - n4);
                byArray[n4 + n3++] = (byte)c2;
                while (n3 < n5 && (c2 = string.charAt(n3)) < '\u0080') {
                    byArray[n4 + n3++] = (byte)c2;
                }
                int n6 = n3 + n4 - segment.limit;
                segment.limit += n6;
                this.size += (long)n6;
                continue;
            }
            if (c2 < '\u0800') {
                this.writeByte(c2 >> 6 | 0xC0);
                this.writeByte(c2 & 0x3F | 0x80);
                ++n3;
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                this.writeByte(c2 >> 12 | 0xE0);
                this.writeByte(c2 >> 6 & 0x3F | 0x80);
                this.writeByte(c2 & 0x3F | 0x80);
                ++n3;
                continue;
            }
            char c3 = c = n3 + 1 < n2 ? string.charAt(n3 + 1) : (char)'\u0000';
            if (c2 > '\udbff' || c < '\udc00' || c > '\udfff') {
                this.writeByte(63);
                ++n3;
                continue;
            }
            int n7 = 65536 + ((c2 & 0xFFFF27FF) << 10 | c & 0xFFFF23FF);
            this.writeByte(n7 >> 18 | 0xF0);
            this.writeByte(n7 >> 12 & 0x3F | 0x80);
            this.writeByte(n7 >> 6 & 0x3F | 0x80);
            this.writeByte(n7 & 0x3F | 0x80);
            n3 += 2;
        }
        return this;
    }

    @Override
    public Buffer writeUtf8CodePoint(int n) {
        if (n < 128) {
            this.writeByte(n);
        } else if (n < 2048) {
            this.writeByte(n >> 6 | 0xC0);
            this.writeByte(n & 0x3F | 0x80);
        } else if (n < 65536) {
            if (n >= 55296 && n <= 57343) {
                this.writeByte(63);
            } else {
                this.writeByte(n >> 12 | 0xE0);
                this.writeByte(n >> 6 & 0x3F | 0x80);
                this.writeByte(n & 0x3F | 0x80);
            }
        } else if (n <= 0x10FFFF) {
            this.writeByte(n >> 18 | 0xF0);
            this.writeByte(n >> 12 & 0x3F | 0x80);
            this.writeByte(n >> 6 & 0x3F | 0x80);
            this.writeByte(n & 0x3F | 0x80);
        } else {
            throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(n));
        }
        return this;
    }

    @Override
    public Buffer writeString(String string, Charset charset) {
        return this.writeString(string, 0, string.length(), charset);
    }

    @Override
    public Buffer writeString(String string, int n, int n2, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalAccessError("beginIndex < 0: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n2 + " < " + n);
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n2 + " > " + string.length());
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (charset.equals(Util.UTF_8)) {
            return this.writeUtf8(string, n, n2);
        }
        byte[] byArray = string.substring(n, n2).getBytes(charset);
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        Util.checkOffsetAndCount(byArray.length, n, n2);
        int n3 = n + n2;
        while (n < n3) {
            Segment segment = this.writableSegment(1);
            int n4 = Math.min(n3 - n, 8192 - segment.limit);
            System.arraycopy(byArray, n, segment.data, segment.limit, n4);
            n += n4;
            segment.limit += n4;
        }
        this.size += (long)n2;
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new IllegalArgumentException("source == null");
        }
        int n2 = n = byteBuffer.remaining();
        while (n2 > 0) {
            Segment segment = this.writableSegment(1);
            int n3 = Math.min(n2, 8192 - segment.limit);
            byteBuffer.get(segment.data, segment.limit, n3);
            n2 -= n3;
            segment.limit += n3;
        }
        this.size += (long)n;
        return n;
    }

    @Override
    public long writeAll(Source source) throws IOException {
        long l;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l2 = 0L;
        while ((l = source.read(this, 8192L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @Override
    public BufferedSink write(Source source, long l) throws IOException {
        while (l > 0L) {
            long l2 = source.read(this, l);
            if (l2 == -1L) {
                throw new EOFException();
            }
            l -= l2;
        }
        return this;
    }

    @Override
    public Buffer writeByte(int n) {
        Segment segment = this.writableSegment(1);
        segment.data[segment.limit++] = (byte)n;
        ++this.size;
        return this;
    }

    @Override
    public Buffer writeShort(int n) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        this.size += 2L;
        return this;
    }

    @Override
    public Buffer writeShortLe(int n) {
        return this.writeShort(Util.reverseBytesShort((short)n));
    }

    @Override
    public Buffer writeInt(int n) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        this.size += 4L;
        return this;
    }

    @Override
    public Buffer writeIntLe(int n) {
        return this.writeInt(Util.reverseBytesInt(n));
    }

    @Override
    public Buffer writeLong(long l) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        segment.limit = n;
        this.size += 8L;
        return this;
    }

    @Override
    public Buffer writeLongLe(long l) {
        return this.writeLong(Util.reverseBytesLong(l));
    }

    @Override
    public Buffer writeDecimalLong(long l) {
        int n;
        if (l == 0L) {
            return this.writeByte(48);
        }
        boolean bl = false;
        if (l < 0L) {
            if ((l = -l) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        int n2 = l < 100000000L ? (l < 10000L ? (l < 100L ? (l < 10L ? 1 : 2) : (l < 1000L ? 3 : 4)) : (l < 1000000L ? (l < 100000L ? 5 : 6) : (l < 10000000L ? 7 : 8))) : (l < 1000000000000L ? (l < 10000000000L ? (l < 1000000000L ? 9 : 10) : (l < 100000000000L ? 11 : 12)) : (l < 1000000000000000L ? (l < 10000000000000L ? 13 : (l < 100000000000000L ? 14 : 15)) : (l < 100000000000000000L ? (l < 10000000000000000L ? 16 : 17) : (n = l < 1000000000000000000L ? 18 : 19))));
        if (bl) {
            ++n;
        }
        Segment segment = this.writableSegment(n);
        byte[] byArray = segment.data;
        int n3 = segment.limit + n;
        while (l != 0L) {
            int n4 = (int)(l % 10L);
            byArray[--n3] = DIGITS[n4];
            l /= 10L;
        }
        if (bl) {
            byArray[--n3] = 45;
        }
        segment.limit += n;
        this.size += (long)n;
        return this;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long l) {
        if (l == 0L) {
            return this.writeByte(48);
        }
        int n = Long.numberOfTrailingZeros(Long.highestOneBit(l)) / 4 + 1;
        Segment segment = this.writableSegment(n);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        for (int i = segment.limit + n - 1; i >= n2; --i) {
            byArray[i] = DIGITS[(int)(l & 0xFL)];
            l >>>= 4;
        }
        segment.limit += n;
        this.size += (long)n;
        return this;
    }

    Segment writableSegment(int n) {
        if (n < 1 || n > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.take());
            return this.head.prev;
        }
        Segment segment = this.head.prev;
        if (segment.limit + n > 8192 || !segment.owner) {
            segment = segment.push(SegmentPool.take());
        }
        return segment;
    }

    @Override
    public void write(Buffer buffer, long l) {
        if (buffer == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (buffer == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(buffer.size, 0L, l);
        while (l > 0L) {
            Segment segment;
            if (l < (long)(buffer.head.limit - buffer.head.pos)) {
                Segment segment2 = segment = this.head != null ? this.head.prev : null;
                if (segment != null && segment.owner && l + (long)segment.limit - (long)(segment.shared ? 0 : segment.pos) <= 8192L) {
                    buffer.head.writeTo(segment, (int)l);
                    buffer.size -= l;
                    this.size += l;
                    return;
                }
                buffer.head = buffer.head.split((int)l);
            }
            segment = buffer.head;
            long l2 = segment.limit - segment.pos;
            buffer.head = segment.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segment);
            } else {
                Segment segment3 = this.head.prev;
                segment3 = segment3.push(segment);
                segment3.compact();
            }
            buffer.size -= l2;
            this.size += l2;
            l -= l2;
        }
    }

    @Override
    public long read(Buffer buffer, long l) {
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.size == 0L) {
            return -1L;
        }
        if (l > this.size) {
            l = this.size;
        }
        buffer.write(this, l);
        return l;
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l) {
        return this.indexOf(by, l, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l, long l2) {
        long l3;
        if (l < 0L || l2 < l) {
            throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.size, l, l2));
        }
        if (l2 > this.size) {
            l2 = this.size;
        }
        if (l == l2) {
            return -1L;
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l < l) {
            for (l3 = this.size; l3 > l; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l) {
                segment = segment.next;
                l3 = l4;
            }
        }
        while (l3 < l2) {
            byte[] byArray = segment.data;
            int n = (int)Math.min((long)segment.limit, (long)segment.pos + l2 - l3);
            for (int i = (int)((long)segment.pos + l - l3); i < n; ++i) {
                if (byArray[i] != by) continue;
                return (long)(i - segment.pos) + l3;
            }
            l = l3 += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) throws IOException {
        long l2;
        if (byteString.size() == 0) {
            throw new IllegalArgumentException("bytes is empty");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l < l) {
            for (l2 = this.size; l2 > l; l2 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l3;
            l2 = 0L;
            while ((l3 = l2 + (long)(segment.limit - segment.pos)) < l) {
                segment = segment.next;
                l2 = l3;
            }
        }
        byte by = byteString.getByte(0);
        int n = byteString.size();
        long l4 = this.size - (long)n + 1L;
        while (l2 < l4) {
            byte[] byArray = segment.data;
            int n2 = (int)Math.min((long)segment.limit, (long)segment.pos + l4 - l2);
            for (int i = (int)((long)segment.pos + l - l2); i < n2; ++i) {
                if (byArray[i] != by || !this.rangeEquals(segment, i + 1, byteString, 1, n)) continue;
                return (long)(i - segment.pos) + l2;
            }
            l = l2 += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l) {
        long l2;
        if (l < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l < l) {
            for (l2 = this.size; l2 > l; l2 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l3;
            l2 = 0L;
            while ((l3 = l2 + (long)(segment.limit - segment.pos)) < l) {
                segment = segment.next;
                l2 = l3;
            }
        }
        if (byteString.size() == 2) {
            byte by = byteString.getByte(0);
            byte by2 = byteString.getByte(1);
            while (l2 < this.size) {
                byte[] byArray = segment.data;
                int n = segment.limit;
                for (int i = (int)((long)segment.pos + l - l2); i < n; ++i) {
                    byte by3 = byArray[i];
                    if (by3 != by && by3 != by2) continue;
                    return (long)(i - segment.pos) + l2;
                }
                l = l2 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        } else {
            byte[] byArray = byteString.internalArray();
            while (l2 < this.size) {
                byte[] byArray2 = segment.data;
                int n = segment.limit;
                for (int i = (int)((long)segment.pos + l - l2); i < n; ++i) {
                    byte by = byArray2[i];
                    for (byte by4 : byArray) {
                        if (by != by4) continue;
                        return (long)(i - segment.pos) + l2;
                    }
                }
                l = l2 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return -1L;
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString) {
        return this.rangeEquals(l, byteString, 0, byteString.size());
    }

    @Override
    public boolean rangeEquals(long l, ByteString byteString, int n, int n2) {
        if (l < 0L || n < 0 || n2 < 0 || this.size - l < (long)n2 || byteString.size() - n < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.getByte(l + (long)i) == byteString.getByte(n + i)) continue;
            return false;
        }
        return true;
    }

    private boolean rangeEquals(Segment segment, int n, ByteString byteString, int n2, int n3) {
        int n4 = segment.limit;
        byte[] byArray = segment.data;
        for (int i = n2; i < n3; ++i) {
            if (n == n4) {
                segment = segment.next;
                byArray = segment.data;
                n = segment.pos;
                n4 = segment.limit;
            }
            if (byArray[n] != byteString.getByte(i)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            arrayList.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList;
    }

    public final ByteString md5() {
        return this.digest("MD5");
    }

    public final ByteString sha1() {
        return this.digest("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest("SHA-256");
    }

    public final ByteString sha512() {
        return this.digest("SHA-512");
    }

    private ByteString digest(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            if (this.head != null) {
                messageDigest.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
                Segment segment = this.head.next;
                while (segment != this.head) {
                    messageDigest.update(segment.data, segment.pos, segment.limit - segment.pos);
                    segment = segment.next;
                }
            }
            return ByteString.of(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public final ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public final ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public final ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    private ByteString hmac(String string, ByteString byteString) {
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            if (this.head != null) {
                mac.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
                Segment segment = this.head.next;
                while (segment != this.head) {
                    mac.update(segment.data, segment.pos, segment.limit - segment.pos);
                    segment = segment.next;
                }
            }
            return ByteString.of(mac.doFinal());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public boolean equals(Object object) {
        long l;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)object;
        if (this.size != buffer.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment segment = this.head;
        Segment segment2 = buffer.head;
        int n = segment.pos;
        int n2 = segment2.pos;
        for (long i = 0L; i < this.size; i += l) {
            l = Math.min(segment.limit - n, segment2.limit - n2);
            int n3 = 0;
            while ((long)n3 < l) {
                if (segment.data[n++] != segment2.data[n2++]) {
                    return false;
                }
                ++n3;
            }
            if (n == segment.limit) {
                segment = segment.next;
                n = segment.pos;
            }
            if (n2 != segment2.limit) continue;
            segment2 = segment2.next;
            n2 = segment2.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n = 1;
        do {
            int n2 = segment.limit;
            for (int i = segment.pos; i < n2; ++i) {
                n = 31 * n + segment.data[i];
            }
        } while ((segment = segment.next) != this.head);
        return n;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public Buffer clone() {
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.head.next = buffer.head.prev = (buffer.head = this.head.sharedCopy());
        Segment segment = this.head.next;
        while (segment != this.head) {
            buffer.head.prev.push(segment.sharedCopy());
            segment = segment.next;
        }
        buffer.size = this.size;
        return buffer;
    }

    public final ByteString snapshot() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
        }
        return this.snapshot((int)this.size);
    }

    public final ByteString snapshot(int n) {
        if (n == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, n);
    }

    public final UnsafeCursor readUnsafe() {
        return this.readUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer != null) {
            throw new IllegalStateException("already attached to a buffer");
        }
        unsafeCursor.buffer = this;
        unsafeCursor.readWrite = false;
        return unsafeCursor;
    }

    public final UnsafeCursor readAndWriteUnsafe() {
        return this.readAndWriteUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readAndWriteUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer != null) {
            throw new IllegalStateException("already attached to a buffer");
        }
        unsafeCursor.buffer = this;
        unsafeCursor.readWrite = true;
        return unsafeCursor;
    }

    public static final class UnsafeCursor
    implements Closeable {
        public Buffer buffer;
        public boolean readWrite;
        private Segment segment;
        public long offset = -1L;
        public byte[] data;
        public int start = -1;
        public int end = -1;

        public final int next() {
            if (this.offset == this.buffer.size) {
                throw new IllegalStateException();
            }
            if (this.offset == -1L) {
                return this.seek(0L);
            }
            return this.seek(this.offset + (long)(this.end - this.start));
        }

        public final int seek(long l) {
            long l2;
            Segment segment;
            if (l < -1L || l > this.buffer.size) {
                throw new ArrayIndexOutOfBoundsException(String.format("offset=%s > size=%s", l, this.buffer.size));
            }
            if (l == -1L || l == this.buffer.size) {
                this.segment = null;
                this.offset = l;
                this.data = null;
                this.start = -1;
                this.end = -1;
                return -1;
            }
            long l3 = 0L;
            long l4 = this.buffer.size;
            Segment segment2 = this.buffer.head;
            Segment segment3 = this.buffer.head;
            if (this.segment != null) {
                long l5 = this.offset - (long)(this.start - this.segment.pos);
                if (l5 > l) {
                    l4 = l5;
                    segment3 = this.segment;
                } else {
                    l3 = l5;
                    segment2 = this.segment;
                }
            }
            if (l4 - l > l - l3) {
                segment = segment2;
                l2 = l3;
                while (l >= l2 + (long)(segment.limit - segment.pos)) {
                    l2 += (long)(segment.limit - segment.pos);
                    segment = segment.next;
                }
            } else {
                segment = segment3;
                for (l2 = l4; l2 > l; l2 -= (long)(segment.limit - segment.pos)) {
                    segment = segment.prev;
                }
            }
            if (this.readWrite && segment.shared) {
                Segment segment4 = segment.unsharedCopy();
                if (this.buffer.head == segment) {
                    this.buffer.head = segment4;
                }
                segment = segment.push(segment4);
                segment.prev.pop();
            }
            this.segment = segment;
            this.offset = l;
            this.data = segment.data;
            this.start = segment.pos + (int)(l - l2);
            this.end = segment.limit;
            return this.end - this.start;
        }

        public final long resizeBuffer(long l) {
            if (this.buffer == null) {
                throw new IllegalStateException("not attached to a buffer");
            }
            if (!this.readWrite) {
                throw new IllegalStateException("resizeBuffer() only permitted for read/write buffers");
            }
            long l2 = this.buffer.size;
            if (l <= l2) {
                int n;
                if (l < 0L) {
                    throw new IllegalArgumentException("newSize < 0: " + l);
                }
                for (long i = l2 - l; i > 0L; i -= (long)n) {
                    Segment segment = this.buffer.head.prev;
                    n = segment.limit - segment.pos;
                    if ((long)n <= i) {
                        this.buffer.head = segment.pop();
                        SegmentPool.recycle(segment);
                        continue;
                    }
                    segment.limit = (int)((long)segment.limit - i);
                    break;
                }
                this.segment = null;
                this.offset = l;
                this.data = null;
                this.start = -1;
                this.end = -1;
            } else if (l > l2) {
                int n;
                boolean bl = true;
                for (long i = l - l2; i > 0L; i -= (long)n) {
                    Segment segment = this.buffer.writableSegment(1);
                    n = (int)Math.min(i, (long)(8192 - segment.limit));
                    segment.limit += n;
                    if (!bl) continue;
                    this.segment = segment;
                    this.offset = l2;
                    this.data = segment.data;
                    this.start = segment.limit - n;
                    this.end = segment.limit;
                    bl = false;
                }
            }
            this.buffer.size = l;
            return l2;
        }

        public final long expandBuffer(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("minByteCount <= 0: " + n);
            }
            if (n > 8192) {
                throw new IllegalArgumentException("minByteCount > Segment.SIZE: " + n);
            }
            if (this.buffer == null) {
                throw new IllegalStateException("not attached to a buffer");
            }
            if (!this.readWrite) {
                throw new IllegalStateException("expandBuffer() only permitted for read/write buffers");
            }
            long l = this.buffer.size;
            Segment segment = this.buffer.writableSegment(n);
            int n2 = 8192 - segment.limit;
            segment.limit = 8192;
            this.buffer.size = l + (long)n2;
            this.segment = segment;
            this.offset = l;
            this.data = segment.data;
            this.start = 8192 - n2;
            this.end = 8192;
            return n2;
        }

        @Override
        public void close() {
            if (this.buffer == null) {
                throw new IllegalStateException("not attached to a buffer");
            }
            this.buffer = null;
            this.segment = null;
            this.offset = -1L;
            this.data = null;
            this.start = -1;
            this.end = -1;
        }
    }
}

