/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Timeout;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketWriter(boolean bl, BufferedSink bufferedSink, Random random) {
        if (bufferedSink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = bl;
        this.sink = bufferedSink;
        this.sinkBuffer = bufferedSink.buffer();
        this.random = random;
        this.maskKey = bl ? new byte[4] : null;
        this.maskCursor = bl ? new Buffer.UnsafeCursor() : null;
    }

    void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClose(int n, ByteString byteString) throws IOException {
        ByteString byteString2 = ByteString.EMPTY;
        if (n != 0 || byteString != null) {
            if (n != 0) {
                WebSocketProtocol.validateCloseCode(n);
            }
            Buffer buffer = new Buffer();
            buffer.writeShort(n);
            if (byteString != null) {
                buffer.write(byteString);
            }
            byteString2 = buffer.readByteString();
        }
        try {
            this.writeControlFrame(8, byteString2);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private void writeControlFrame(int n, ByteString byteString) throws IOException {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n2 = byteString.size();
        if ((long)n2 > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int n3 = 0x80 | n;
        this.sinkBuffer.writeByte(n3);
        int n4 = n2;
        if (this.isClient) {
            this.sinkBuffer.writeByte(n4 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (n2 > 0) {
                long l = this.sinkBuffer.size();
                this.sinkBuffer.write(byteString);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(n4);
            this.sinkBuffer.write(byteString);
        }
        this.sink.flush();
    }

    Sink newMessageSink(int n, long l) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = n;
        this.frameSink.contentLength = l;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    void writeMessageFrame(int n, long l, boolean bl, boolean bl2) throws IOException {
        int n2;
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n3 = n2 = bl ? n : 0;
        if (bl2) {
            n2 |= 0x80;
        }
        this.sinkBuffer.writeByte(n2);
        int n4 = 0;
        if (this.isClient) {
            n4 |= 0x80;
        }
        if (l <= 125L) {
            this.sinkBuffer.writeByte(n4 |= (int)l);
        } else if (l <= 65535L) {
            this.sinkBuffer.writeByte(n4 |= 0x7E);
            this.sinkBuffer.writeShort((int)l);
        } else {
            this.sinkBuffer.writeByte(n4 |= 0x7F);
            this.sinkBuffer.writeLong(l);
        }
        if (this.isClient) {
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (l > 0L) {
                long l2 = this.sinkBuffer.size();
                this.sinkBuffer.write(this.buffer, l);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l2);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.write(this.buffer, l);
        }
        this.sink.emit();
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.buffer.write(buffer, l);
            boolean bl = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long l2 = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (l2 > 0L && !bl) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, l2, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

