/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    boolean isFinalFrame;
    boolean isControlFrame;
    private final Buffer controlFrameBuffer = new Buffer();
    private final Buffer messageFrameBuffer = new Buffer();
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketReader(boolean bl, BufferedSource bufferedSource, FrameCallback frameCallback) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        if (frameCallback == null) {
            throw new NullPointerException("frameCallback == null");
        }
        this.isClient = bl;
        this.source = bufferedSource;
        this.frameCallback = frameCallback;
        this.maskKey = bl ? null : new byte[4];
        this.maskCursor = bl ? null : new Buffer.UnsafeCursor();
    }

    void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader() throws IOException {
        boolean bl;
        boolean bl2;
        int n;
        if (this.closed) {
            throw new IOException("closed");
        }
        long l = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            n = this.source.readByte() & 0xFF;
        }
        finally {
            this.source.timeout().timeout(l, TimeUnit.NANOSECONDS);
        }
        this.opcode = n & 0xF;
        this.isFinalFrame = (n & 0x80) != 0;
        boolean bl3 = this.isControlFrame = (n & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean bl4 = (n & 0x40) != 0;
        boolean bl5 = (n & 0x20) != 0;
        boolean bl6 = bl2 = (n & 0x10) != 0;
        if (bl4 || bl5 || bl2) {
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        int n2 = this.source.readByte() & 0xFF;
        boolean bl7 = bl = (n2 & 0x80) != 0;
        if (bl == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = n2 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = (long)this.source.readShort() & 0xFFFFL;
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Long.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (bl) {
            this.source.readFully(this.maskKey);
        }
    }

    private void readControlFrame() throws IOException {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                this.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                break;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                break;
            }
            case 8: {
                int n = 1005;
                String string = "";
                long l = this.controlFrameBuffer.size();
                if (l == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (l != 0L) {
                    n = this.controlFrameBuffer.readShort();
                    string = this.controlFrameBuffer.readUtf8();
                    String string2 = WebSocketProtocol.closeCodeExceptionMessage(n);
                    if (string2 != null) {
                        throw new ProtocolException(string2);
                    }
                }
                this.frameCallback.onReadClose(n, string);
                this.closed = true;
                break;
            }
            default: {
                throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
            }
        }
    }

    private void readMessageFrame() throws IOException {
        int n = this.opcode;
        if (n != 1 && n != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n));
        }
        this.readMessage();
        if (n == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage() throws IOException {
        block4: {
            do {
                if (this.closed) {
                    throw new IOException("closed");
                }
                if (this.frameLength > 0L) {
                    this.source.readFully(this.messageFrameBuffer, this.frameLength);
                    if (!this.isClient) {
                        this.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                        this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                        WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                }
                if (this.isFinalFrame) break block4;
                this.readUntilNonControlFrame();
            } while (this.opcode == 0);
            throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

