/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import okhttp3.internal.Util;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private OkHostnameVerifier() {
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            return this.verify(string, (X509Certificate)certificateArray[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    public boolean verify(String string, X509Certificate x509Certificate) {
        return Util.verifyAsIpAddress(string) ? this.verifyIpAddress(string, x509Certificate) : this.verifyHostname(string, x509Certificate);
    }

    private boolean verifyIpAddress(String string, X509Certificate x509Certificate) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames(x509Certificate, 7);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(list.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String string, X509Certificate x509Certificate) {
        string = string.toLowerCase(Locale.US);
        List<String> list = OkHostnameVerifier.getSubjectAltNames(x509Certificate, 2);
        for (String string2 : list) {
            if (!this.verifyHostname(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static List<String> allSubjectAltNames(X509Certificate x509Certificate) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames(x509Certificate, 7);
        List<String> list2 = OkHostnameVerifier.getSubjectAltNames(x509Certificate, 2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private static List<String> getSubjectAltNames(X509Certificate x509Certificate, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
            for (List<?> list : collection) {
                String string;
                Integer n2;
                List<?> list2 = list;
                if (list2 == null || list2.size() < 2 || (n2 = (Integer)list2.get(0)) == null || n2 != n || (string = (String)list2.get(1)) == null) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    public boolean verifyHostname(String string, String string2) {
        if (string == null || string.length() == 0 || string.startsWith(".") || string.endsWith("..")) {
            return false;
        }
        if (string2 == null || string2.length() == 0 || string2.startsWith(".") || string2.endsWith("..")) {
            return false;
        }
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        if (!string2.endsWith(".")) {
            string2 = string2 + '.';
        }
        if (!(string2 = string2.toLowerCase(Locale.US)).contains("*")) {
            return string.equals(string2);
        }
        if (!string2.startsWith("*.") || string2.indexOf(42, 1) != -1) {
            return false;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        if ("*.".equals(string2)) {
            return false;
        }
        String string3 = string2.substring(1);
        if (!string.endsWith(string3)) {
            return false;
        }
        int n = string.length() - string3.length();
        return n <= 0 || string.lastIndexOf(46, n - 1) == -1;
    }
}

